#include "IRremote.h"
#include "mbed.h"

int IR_cnt, IR_state, IR_bit_cnt, IR_temp;
char IR_buf[4]={0xFF,0xFF,0xFF,0xFF};
//IR Timer
void IR_check()
{
    if(IR_cnt<150) {
        IR_cnt++;
    }
    if(IR_cnt>=150) {
        IR_state=1;
    }
}

//IR Receive
void IR_start()
{
    switch(IR_state) {
        case 1:
            if((IR_cnt>85)&&(IR_cnt<140)) {
                IR_state=2;    // Lead
                IR_bit_cnt=IR_temp=0;
            }
            break;
        case 2:
            if(IR_cnt> 25) {
                IR_state=1;    // Error
                break;
            } else if(IR_cnt>=15) {
                IR_temp|=0x80;      // Data 1 : 2.250ms(22)(0.56ms+1.69ms ) / 2ms
            } else if(IR_cnt>= 8) {
                IR_temp|=0x00;      // Data 0 : 1.125ms(12)(0.56ms+0.565ms) / 1ms
            } else               {
                IR_state=1;    // Error
                break;
            }
            if((++IR_bit_cnt%8)==0) {
                IR_buf[(IR_bit_cnt/8)-1]=IR_temp;
                IR_temp=0;
                if(IR_bit_cnt>=32) {
                    IR_state=1;
                    IR_bit_cnt=0;
                }
            }
            IR_temp>>=1;
            break;
    }
    IR_cnt=0;
}

IRremote::IRremote(PinName pin) : _pin(pin)
{
    _pin.mode(PullUp);
    _pin.fall(&IR_start);
    IR_timer.attach_us(&IR_check, 100.0);
}

char IRremote::read(int ir_i)
{
    return IR_buf[ir_i];
}
char IRremote::readclear(int ir_i)
{
    char IR_rx;
    IR_rx = IR_buf[ir_i];
    IR_buf[ir_i]=0xFF;
    return IR_rx;
}
void IRremote::clear()
{
    for(int i=0; i<4; i++) {
        IR_buf[i]=0xFF;
    }
}
