/*
The MIT License (MIT)

Copyright (c) 2016 British Broadcasting Corporation.
This software is provided by Lancaster University by arrangement with the BBC.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#include "MicroBit.h"
#include "MicroBitSamples.h"

#ifdef MICROBIT_SAMPLE_BT_SYNC

MicroBit uBit;

uint16_t value;

void increment()
{
    if (value < 57) {
        value = value + 1;
        // Indicate that a new sample is available
        MicroBitEvent e(MICROBIT_ID_VALUE, MICROBIT_VALUE_EVT_UPDATE);
    }

#if CONFIG_ENABLED(MICROBIT_DBG)
    if(SERIAL_DEBUG) SERIAL_DEBUG->printf("++\r\n");
#endif
}

void decrement()
{
    if (value > 48) {
        value = value - 1;
        // Indicate that a new sample is available
        MicroBitEvent e(MICROBIT_ID_VALUE, MICROBIT_VALUE_EVT_UPDATE);
    }

#if CONFIG_ENABLED(MICROBIT_DBG)
    if(SERIAL_DEBUG) SERIAL_DEBUG->printf("--\r\n");
#endif
}

void onValueChanged(MicroBitEvent e)
{
#if CONFIG_ENABLED(MICROBIT_DBG)
    if(SERIAL_DEBUG) SERIAL_DEBUG->printf("valueChanged\r\n");
#endif
    uBit.display.printChar(value);
}

int main()
{
    // Initialise the micro:bit runtime.
    uBit.init();
    
    MicroBitSerial serial(USBTX, USBRX);

#if CONFIG_ENABLED(MICROBIT_DBG)
    if(SERIAL_DEBUG) SERIAL_DEBUG->printf("Init...\r\n");
#endif
    
    value = 48;

    new MicroBitValueService(*uBit.ble, &value);


#if CONFIG_ENABLED(MICROBIT_DBG)
    if(SERIAL_DEBUG) SERIAL_DEBUG->printf("Started!\r\n");
#endif

    uBit.display.scroll("Hi Bernard Controls! from GFI :)");

    while(1) {
        if (uBit.buttonA.isPressed()) {
            decrement();
        } else if (uBit.buttonB.isPressed()) {
            increment();
        }
        uBit.display.printChar(value);
        uBit.sleep(100);
    }
}

#endif
