/*
The MIT License (MIT)

Copyright (c) 2016 British Broadcasting Corporation.
This software is provided by Lancaster University by arrangement with the BBC.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#ifndef MICROBIT_VALUE_SERVICE_H
#define MICROBIT_VALUE_SERVICE_H

#include "ble/BLE.h"
#include "MicroBitConfig.h"
#include "EventModel.h"

#define MICROBIT_VALUE_EVT_UPDATE 1

// UUIDs for our service and characteristics
extern const uint8_t  MicroBitValueServiceUUID[];
extern const uint8_t  MicroBitValueServiceDataUUID[];
extern const uint8_t  MicroBitValueServiceBearingUUID[];
extern const uint8_t  MicroBitValueServicePeriodUUID[];


/**
  * Class definition for the MicroBit BLE Value Service.
  * Provides access to live data via BLE, and provides basic configuration options.
  */
class MicroBitValueService
{
    public:

    /**
      * Constructor.
      * Create a representation of the MagnetometerService.
      * @param _ble The instance of a BLE device that we're running on.
      * @param _value An instance of MicroBitCompass to use as our Magnetometer source.
      */
    MicroBitValueService(BLEDevice &_ble, uint16_t *_value);

    private:

    /**
      * Callback. Invoked when any of our attributes are written via BLE.
      */
    void onDataWritten(const GattWriteCallbackParams *params);

    /**
     * Value update callback
     */
    void valueUpdate(MicroBitEvent e);

    // Bluetooth stack we're running on.
    BLEDevice           &ble;
    uint16_t            *value;

    // memory for our 8 bit control characteristics.
    uint16_t            valueCharacteristicBuffer;

    // Handles to access each characteristic when they are held by Soft Device.
    GattAttribute::Handle_t valueCharacteristicHandle;
};

#endif
