#include "mbed.h"
#include "Adafruit_SSD1306.h"   // Adafruit_GFX library

#define NUM_CHAR    16

Serial      pc(SERIAL_TX, SERIAL_RX);
DigitalOut  greenLed(LED1);
DigitalOut  redLed(PA_12);
AnalogOut   myAnalogOut(PA_4);
AnalogIn    lightSensor(PA_0);
Timer       t1, t2;
Ticker       t3, t4;
InterruptIn   myButton(PC_13);
InterruptIn   exButton(PC_11);








BusOut my7Seg(PA_8, PA_9, PA_10, PC_9, PC_8, PC_7, PC_6, PA_11); // 8bit data
            // LSB,                                      , MSB
uint8_t pic1Logo[64 * 128 / 8] =
{
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0xFC,0xCC,0x0C,0x0C,0x1C,0x38,0x70,0x70,
0xE0,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x80,0x80,0x80,0x00,0x00,0x00,
0x00,0x01,0x01,0x07,0x0E,0x1C,0x38,0xF0,0xF0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x7C,0xFC,0xB6,0x32,0x02,0x7F,0xFE,0xF3,0xB3,0x81,0x81,0x81,0x81,0x83,0x87,0xFE,
0x78,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x03,0x1F,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x01,0x01,0x01,0x03,0x03,0x13,0x3F,0xFF,0xF3,0xF3,0xF3,0xFB,0xF9,0xF9,0xFC,
0xFC,0xFC,0xFE,0x7E,0x3F,0x1F,0x07,0x00,0x00,0x80,0xFF,0x3F,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xF0,0x58,0x78,0x38,0x08,0x1C,0x1C,0x18,0x18,0x18,0x78,0xB0,0xE0,
0x80,0x00,0x00,0x00,0xE0,0xFC,0x1C,0x06,0x07,0x07,0x07,0x03,0x03,0x03,0x03,0x01,
0x01,0x00,0x00,0x00,0x00,0x80,0xE0,0xF0,0x3C,0x0F,0x01,0x00,0xC0,0xF0,0x78,0x38,
0x3C,0x0C,0x0C,0x0C,0x34,0x34,0x8C,0xF8,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x03,0x06,0x1A,0x10,0x18,0x18,0x18,0x18,0x08,0x18,0x3C,0x7E,0x67,
0x63,0xE0,0xF0,0x7E,0x1F,0x00,0x00,0x00,0x80,0x80,0xC0,0xC0,0xA0,0xF0,0xF0,0xF8,
0xB8,0x18,0x0C,0x0F,0x3F,0x7B,0x71,0x70,0x60,0x70,0x30,0x32,0x1B,0x1F,0x18,0x30,
0x30,0x20,0x20,0x70,0x38,0x0C,0x1D,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x80,0xC0,0x40,0x60,0x60,0x20,0x20,0x20,0x20,0x30,0x38,0x3C,0x3E,
0x36,0x23,0x63,0x46,0xC6,0x86,0x06,0x07,0x03,0x03,0x03,0x01,0x01,0x80,0xC0,0x41,
0x63,0x67,0x3E,0x3C,0x38,0x30,0x30,0x30,0x30,0x30,0x20,0x60,0x60,0xC0,0xC0,0xC0,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x03,0x07,0x06,0x04,0x0C,0x0C,0x0C,0x0C,0x0C,0x04,0x04,0x04,0x04,
0x04,0x06,0x06,0x06,0x07,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x0F,0x0E,0x14,
0x14,0x14,0x14,0x14,0x14,0x14,0x1C,0x0C,0x0C,0x0C,0x0C,0x04,0x04,0x06,0x03,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

uint8_t pic2Logo[64 * 128 / 8] =
{
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x80,0xE0,0x78,0x3C,0x0E,0x06,0x03,0x03,0x03,0x03,0x03,0x03,0x0E,
0x3C,0xF8,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xF8,0xF8,0x08,0x0C,0x04,0x04,0x06,0x04,0x0C,0x0C,0x0C,0xBC,0xF8,0xE0,
0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,
0xF0,0xFC,0xBE,0x1F,0x09,0x08,0xCC,0xCC,0xCC,0x08,0x18,0xB0,0xF0,0x38,0x18,0x08,
0x08,0xCF,0xCF,0xCE,0x08,0x18,0xF0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x60,0xE0,0xF0,0x98,0x08,0x04,0x04,0x04,0x04,0x04,
0x04,0x0C,0x5C,0xF8,0xE0,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x01,0x03,0x07,0x07,0x04,0x08,0x0C,0x0C,0x06,0x06,0x06,0x07,0x07,0x07,
0x0E,0x0E,0x0E,0x1C,0x18,0x38,0x30,0x70,0x70,0x60,0xE0,0xC0,0xC0,0x80,0x80,0xFF,
0xFF,0xFF,0x73,0xF3,0xE6,0xE6,0xE4,0xE4,0xE6,0xE6,0xE2,0xE3,0xE1,0xE3,0xE2,0xE6,
0xE6,0xE4,0xE4,0xFE,0xFE,0xFF,0x01,0x00,0x00,0x80,0x80,0x80,0xC0,0xC0,0xC0,0x60,
0x60,0x60,0x30,0x30,0x38,0x18,0x0C,0x0D,0x07,0x07,0x07,0x06,0x06,0x06,0x06,0x06,
0x06,0x06,0x06,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x03,
0x07,0x3F,0xF8,0xE0,0x81,0x01,0x03,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x07,
0x07,0x07,0x03,0x03,0xFF,0xFF,0xFF,0x03,0x03,0x01,0x01,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x01,0x07,0x1E,0x38,0x70,0xE0,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC1,0xF7,0x7F,0x3E,0x1C,0x1C,0x18,
0x18,0x08,0x18,0x38,0xF8,0xEF,0xCF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0xC0,0x60,0x60,0x20,0x20,0x20,0x30,
0x30,0x30,0x30,0x30,0x30,0x30,0x3C,0x3E,0x37,0x33,0xF0,0xE0,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xC0,0xE0,0x21,0x27,0x3F,0x3E,0x3C,0x30,0x30,0x30,0x30,0x30,0x30,
0x30,0x30,0x30,0x30,0x70,0x60,0xE0,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
0x02,0x02,0x02,0x02,0x02,0x03,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

uint8_t pic3Logo[64 * 128 / 8] =
{
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0xC0,0x40,0x60,
0x30,0x30,0x20,0x20,0xE0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x80,0xC0,0xE0,0x70,0x38,0x1C,0x0C,0x0E,0x07,0x03,0x01,0x00,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xF0,
0x7C,0x0F,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xF8,0x8C,0x0C,0x06,
0x06,0x06,0x06,0x07,0x07,0x64,0xEC,0xFC,0xF4,0x04,0x64,0x7C,0xFC,0xF0,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,
0xC0,0x00,0x00,0x00,0x07,0x1F,0x3E,0x7E,0x7C,0xFC,0xFC,0xF8,0xF8,0xF9,0xFB,0xFB,
0xFA,0xFA,0xFA,0xFA,0xF3,0xFF,0x3F,0x03,0x03,0x02,0x03,0x01,0x01,0x01,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xF0,0xF0,0x10,0x18,0x18,0x0C,0x04,0x0C,0x1C,0x30,0x30,0x70,0xC0,0xC0,0x00,0x01,
0x0F,0x1F,0x3C,0x70,0xE0,0xC0,0x80,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x03,
0x03,0x03,0x03,0x07,0x07,0x07,0x06,0x3E,0xFC,0xE0,0x80,0x00,0x00,0x00,0xC0,0xC0,
0xE0,0x30,0x10,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x38,0x30,0xF0,0xE0,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0x07,0x07,0x0E,0x1C,0x18,0x1C,0x14,0x1C,0x0C,0x0C,0x0D,0x0F,0x0F,0x0D,0x1C,
0x18,0x18,0x38,0x38,0x38,0x1C,0x0F,0x0F,0x07,0x86,0xCE,0xFC,0x7C,0x38,0x38,0x70,
0x50,0xE0,0xE0,0xE0,0xC0,0x80,0x80,0x00,0x00,0x07,0x9F,0xFE,0xF8,0x98,0x9A,0x3F,
0x1F,0x1E,0x0C,0x04,0x04,0x0C,0x0C,0x0C,0x04,0x04,0x05,0x07,0x07,0x03,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xF0,0xB0,0x90,0x98,0x88,
0x88,0x88,0x88,0x88,0x8C,0x8C,0x8C,0x8E,0x8F,0x8B,0x89,0x98,0x98,0x98,0xF0,0xE0,
0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x41,0xE3,0xB3,0xB3,0xBB,0x98,0x89,0x8B,0x8F,
0x8F,0x8E,0x8C,0x88,0x88,0x88,0x88,0x88,0x88,0x98,0x98,0xB0,0xF0,0x40,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};


///
int location = 0;
///


bool    flagOne = 0;
 
void OneSecond() {
    flagOne = 1;
}
 
int    flagDown = 0;       // 1: speed down
int    flagUp = 0;         // 1: speed up

char    rxData[5];
bool    flagRx = 0;
int     dir = 1;        // 1: increase, -1: decrease
bool    flagT3 = 0;
bool    modeT3 = 0;     // 0: stop, 1: working

bool    currentMode = 1;
int     currentPos = 0;

void ReceiveInt() {
    char inChar;
    static char rxCount = 0;
    static char rxBuf[4];
    
    while(1 == pc.readable()) {
        inChar = pc.getc();
        if ('<' == inChar){
            rxCount = 1;            
        }
        else if (rxCount > 0 && rxCount < 5) {
            rxBuf[rxCount-1] = inChar;
            rxCount++;   
        }
        else if (5 == rxCount && '>' == inChar) {
            rxCount = 0;
            flagRx = 1;
            memcpy(rxData, rxBuf, 4);
//            pc.putc(rxData[0]);
//            pc.putc(rxData[1]);
//            pc.putc(rxData[2]);
//            pc.putc(rxData[3]);
 
//            pc.puts(rxData);  
        }
        else {
            rxCount = 0;
        }
    }
}

void tickerFunc3() {
    flagT3 = 1;
}


I2C         I2C_Oled(PB_7, PA_15);       // SDA, SCL
Adafruit_SSD1306_I2c    myOled(I2C_Oled, PD_2, 0x78, 64, 128);    //  reset pin doesn't effect


 
void Btn1Down() {
//    pc.puts("1 pused\n");   // for debugging
    t1.start();
}
 
void Btn1Up() {
//    pc.puts("1 released\n");    // for debugging
    if (t1.read() > 0 ) {
        flagUp = 1;
    }
    t1.stop();
    t1.reset();
}
 
void Btn2Down() {
//    pc.puts("2 pused\n");   // for debugging
    t2.start();    
}
 
void Btn2Up() {
//    pc.puts("2 released\n");    // for debugging
    if (t2.read() > 0) {
        flagDown = 1;
    }
    t2.stop();
    t2.reset();
}

// 
int main()
{   
    pc.baud(115200);
    pc.puts("\nStart!\n");    
 
    myButton.disable_irq();     // to avoid unexpected interrupt
    exButton.disable_irq();     // to avoid unexpected interrupt
    
    pc.attach(&ReceiveInt, Serial::RxIrq);      // RxIrq, TxIrq




    myButton.fall(&Btn1Down);
    myButton.rise(&Btn1Up);
    exButton.fall(&Btn2Down);
    exButton.rise(&Btn2Up);
 
    I2C_Oled.frequency(400000);     // 400kHz clock
 
    myButton.enable_irq();     // enable IRQ
    exButton.enable_irq();     // enable IRQ
    



    I2C     I2C_Oled(PB_7, PA_15);       // SDA, SCL
    I2C_Oled.frequency(400000);     // 400kHz clock
    Adafruit_SSD1306_I2c    myOled(I2C_Oled, PD_2, 0x78, 64, 128);    //  reset pin doesn't effect

    myOled.splash();      // logo output
    myOled.display();
    wait(0.5);
    
    myOled.clearDisplay();  // clear buffer     
    myOled.printf("%u x %u OLED Display\r\n", myOled.width(), myOled.height());
    myOled.display();       // show a image on the OLED
    wait(1);

    myButton.enable_irq();     // enable IRQ
    exButton.enable_irq();     // enable IRQ
    
    t3.attach(&tickerFunc3, 0.1);       // ticker3 start
    
    time_t seconds = time(NULL);
    
    set_time(1651121217);  // Set RTC time to 2022-4월-28, PM 1:46:57
    pc.printf("Time as a basic string = %s", ctime(&seconds));

    char buffer[32];
    strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
    pc.printf("1) Time as a custom formatted string = %s", buffer);
    strftime(buffer, 32, "%y-%m-%d, %H:%M:%S\n", localtime(&seconds));
    pc.printf("2) Time as a custom formatted string = %s", buffer);    

    char tmpCommand[3];
    int rxVal;
    char    val7Seg[NUM_CHAR] = {0x3F, 0x06, 0x5B, 0x4F, 0x66, 0x6D, 0x7D, 0x07, 0x7F, 0x6F, 0x77, 0x7C, 0x39, 0x5E, 0x79, 0x71};

    modeT3 = 1;
    my7Seg = 0xFF;
      
    uint16_t n = 0;

    while(1)
    {
        if (1 == flagOne) {
            flagOne = 0;
            seconds = time(NULL);

        }
 
         if (t1.read() > 1.0f) {
            flagUp = 2;
            t1.stop();
            t1.reset();
        }
               
        if (t2.read() > 1.0f) {
            flagDown = 2;
            t2.stop();
            t2.reset();
        }
        //myOled.clearDisplay();
        //myOled.drawBitmap(location, 0, pic2Logo, 128, 64, 1);
        //myOled.display();
        
        if (1 == flagDown && 1 == currentMode){     // check the external button action
            flagDown = 0;
            location = location - 10;
            myOled.clearDisplay();
            myOled.drawBitmap(location, 0, pic1Logo, 128, 64, 1);
            myOled.display();
            //wait(1);
        }
        else if (2 == flagDown && 1 == currentMode) {
            flagDown = 0;
            location = 0;
            myOled.clearDisplay();
            myOled.drawBitmap(location, 0, pic2Logo, 128, 64, 1);
            myOled.display();
            //wait(1);
        }
            
        if (1 == flagUp && 1 == currentMode) {      // check the internal button action
            flagUp = 0;
            location = location + 10;
            myOled.clearDisplay();
            myOled.drawBitmap(location, 0, pic3Logo, 128, 64, 1);
            myOled.display();
            //wait(1);
        }
        
        else if (2 == flagUp) {
            flagUp = 0;
            location = 0;
            //currentMode = !currentMode;
            myOled.clearDisplay();
            myOled.drawBitmap(location, 0, pic2Logo, 128, 64, 1);
            myOled.display();
            //wait(1);
        }







    }
}
