#include "mbed.h"
#include "Adafruit_SSD1306.h"   // Adafruit_GFX library

#define NUM_CHAR    16

Serial      pc(SERIAL_TX, SERIAL_RX);
DigitalOut  greenLed(LED1);
DigitalOut  redLed(PA_12);
AnalogOut   myAnalogOut(PA_4);
AnalogIn    lightSensor(PA_0);
Timer       t1, t2;
Ticker       t3, t4;
InterruptIn   myButton(PC_13);
InterruptIn   exButton(PC_11);

BusOut my7Seg(PA_8, PA_9, PA_10, PC_9, PC_8, PC_7, PC_6, PA_11); // 8bit data
            // LSB,                                      , MSB

char    rxData[5];
bool    flagRx = 0;
int     dir = 1;        // 1: increase, -1: decrease
bool    flagT3 = 0;
bool    modeT3 = 0;     // 0: stop, 1: working




void ReceiveInt() {
    char inChar;
    static char rxCount = 0;
    static char rxBuf[4];
    
    while(1 == pc.readable()) {
        inChar = pc.getc();
        if ('<' == inChar){
            rxCount = 1;            
        }
        else if (rxCount > 0 && rxCount < 5) {
            rxBuf[rxCount-1] = inChar;
            rxCount++;   
        }
        else if (5 == rxCount && '>' == inChar) {
            rxCount = 0;
            flagRx = 1;
            memcpy(rxData, rxBuf, 4);
//            pc.putc(rxData[0]);
//            pc.putc(rxData[1]);
//            pc.putc(rxData[2]);
//            pc.putc(rxData[3]);
 
//            pc.puts(rxData);  
        }
        else {
            rxCount = 0;
        }
    }
}

void tickerFunc3() {
    flagT3 = 1;
}
// 버튼1을 2초 이상 누르면 LED 변환 (led1, led2 선택)
// 버튼2를 2초 이상 누르면 현재 LED 초기화 (초기 깜빡임 속도 0.5초)
// 버튼1을 살짝 누르면 깜빡임 속도 감소, 버튼2를 살짝 누르면 깜빡임 속도 증가 (0.1초 ~ 1초, 0.1초 단계)


//// 스위치 플래그
int    flagDown = 0;       // 1: speed down, 2: change LED
int    flagUp = 0;         // 1: speed up, 2: reset biliking speed

void Btn1Down() {
//    pc.puts("1 pushed\n");   // for debugging
    t1.start();
}

void Btn1Up() {
//    pc.puts("1 released\n");    // for debugging
    float tempT1 = t1.read();
    if (tempT1 > 2.0f) {
        flagDown = 2;
    }
    else if (tempT1 > 0) {
        flagDown = 1;
    }
    t1.stop();
    t1.reset();
}

void Btn2Down() {
//    pc.puts("2 pushed\n");   // for debugging
    t2.start();    
}
//플래그 업이 2가 되면 설정모드.
void Btn2Up() {
//    pc.puts("2 released\n");    // for debugging
    float tempT2 = t2.read();
    if (tempT2 > 2.0f) {
        flagUp = 2;
    }
    //플래그 업이 1이면 그냥 눌렀을때 
    else if (tempT2 > 0) {
        flagUp = 1;
    }
    t2.stop();
    t2.reset();
}


// 
int main()
{   
    pc.baud(115200);
    pc.puts("\nStart!\n");    
 
    myButton.disable_irq();     // to avoid unexpected interrupt
    exButton.disable_irq();     // to avoid unexpected interrupt
    
    pc.attach(&ReceiveInt, Serial::RxIrq);      // RxIrq, TxIrq
    myButton.fall(&Btn1Down);
    myButton.rise(&Btn1Up);
    exButton.fall(&Btn2Down);
    exButton.rise(&Btn2Up);

    I2C     I2C_Oled(PB_7, PA_15);       // SDA, SCL
    I2C_Oled.frequency(400000);     // 400kHz clock
    Adafruit_SSD1306_I2c    myOled(I2C_Oled, PD_2, 0x78, 64, 128);    //  reset pin doesn't effect

    myOled.splash();      // logo output
    myOled.display();
    wait(0.5);
    
    myOled.clearDisplay();  // clear buffer     
    myOled.printf("%u x %u OLED Display\r\n", myOled.width(), myOled.height());
    myOled.display();       // show a image on the OLED
    wait(1);

    myButton.enable_irq();     // enable IRQ
    exButton.enable_irq();     // enable IRQ
    
    t3.attach(&tickerFunc3, 0.1);       // ticker3 start
    
    time_t seconds = time(NULL);
    
    set_time(1651121217);  // Set RTC time to 2022-4월-28, PM 1:46:57
    pc.printf("Time as a basic string = %s", ctime(&seconds));

    char buffer[32];
    strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
    pc.printf("1) Time as a custom formatted string = %s", buffer);
    strftime(buffer, 32, "%y-%m-%d, %H:%M:%S\n", localtime(&seconds));
    pc.printf("2) Time as a custom formatted string = %s", buffer);    

    char tmpCommand[3];
    int rxVal;
    char    val7Seg[NUM_CHAR] = {0x3F, 0x06, 0x5B, 0x4F, 0x66, 0x6D, 0x7D, 0x07, 0x7F, 0x6F, 0x77, 0x7C, 0x39, 0x5E, 0x79, 0x71};

    modeT3 = 1;
    my7Seg = 0xFF;
      
    // 엔이 여깄음
    uint16_t n = 0;

    //커서 설정
    int cursor = 0;

    //에딧 모드 설정
    int edit = 0;
    
    //뇌절
    int brain = 0; 
    while(1)
    {
        
        //if (1 == flagT3) {
            //flagT3 = 0;
            //n = n + dir;
            //myOled.clearDisplay();      
            //myOled.setTextCursor(1, 5);
            //myOled.printf("%S",buffer);
            //myOled.display();
            //my7Seg = ~val7Seg[n%16] & 0x7F;
        //}
        
        if (1 == flagRx){
            flagRx = 0;
            tmpCommand[0] = rxData[0];
            tmpCommand[1] = rxData[1];
            tmpCommand[2] = 0;
            rxVal = atoi(rxData+2);
            
            if (0 == strcmp(tmpCommand, "LD")) {        // control a LED
                pc.printf("val = %d\n", rxVal);
                
                greenLed = (1 == rxVal)? 1:0;
//                greenLed = rxVal? 1:0;
            }
            if (0 == strcmp(tmpCommand, "RE")) {        // reset all variables
                greenLed = 0;
                redLed = 1;
                n = 0;
            }
            //greenLed = !greenLed;
            //time_t seconds = time(NULL);
            
        //pc.printf("\nTime as seconds since Janurary 1, 1970 = %u\n", (unsigned int)seconds);
            
        //pc.printf("Time as a basic string = %s" , ctime(&seconds));
            

            
       }  

    greenLed = !greenLed;
    time_t seconds = time(NULL);
            
    pc.printf("\nTime as seconds since Janurary 1, 1970 = %u\n", (unsigned int)seconds);
    pc.printf("Time as a basic string = %s" , ctime(&seconds));
    
    //컴포트 마스터 나오는거
    char buffer[32];
    strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
    pc.printf("1) Time as custom formatted string = %s", buffer);
    strftime(buffer, 32, "%y-%m-%d, %H:%M:%S\n", localtime(&seconds));
    pc.printf("2) Time as a custom formatted string = %s", buffer);
 
 
    // 오엘이디 나오는거 평상시
    if (1 == flagT3) {
        flagT3 = 0;
        n = n + dir;
        myOled.clearDisplay();      
        myOled.setTextCursor(1, 5);
        myOled.printf("%S",buffer);
        pc.printf(buffer);
        myOled.display();
        my7Seg = ~val7Seg[n%16] & 0x7F;
    }

        
    // 2초 이상 누른거 (버튼 1)
        if (2 == flagDown) {
            edit = edit + 1;
        }
        if (edit == 2){
            edit = 0;
            }
        switch(edit){
            case 0:
                pc.puts("edit mode off");
                flagDown = 0;
                brain = 0;
                break;
            case 1:
                pc.puts("edit mode on");
                brain = 1;    
                edit = 1;       // ??; H.S.Lee
    //            flagDown = 0;
    //            currentLED = !currentLED;
    //            pc.puts(selLED[currentLED]);
                    {
                         
            // 오엘이디 외부 버튼을 눌렀다.
            // 살짝 누른거 (버튼 1)
                flagDown = 0;
                break;
        }    
        if (1 == brain && edit == 1) {
            flagDown = 0;
            pc.puts("Cursor Select.\n");
    //      float tempVal = blinkSpeed[currentLED];
    //      tempVal = tempVal + 0.1f;
    //      if (tempVal > 1.0f) tempVal = 1.0f;
    //      if (0 == currentLED) t3.attach(&BlinkLED1, tempVal);
    //              else t4.attach(&BlinkLED2, tempVal);
    //              blinkSpeed[currentLED] = tempVal;

            switch(cursor){
                case 0:
                    pc.puts(" second.\n");
                    break;
                case 1:
                    pc.puts(" minute.\n");
                    break;
                case 2:
                    pc.puts(" hour.\n");
                    break;
                case 3:
                    pc.puts(" day.\n");
                    break;
                case 4: 
                    pc.puts(" month.\n");
                    break;
                case 5: 
                    pc.puts(" year.\n");
                    break;
            }
            brain = 0;
            cursor += 1;         
            if (cursor == 6){
                cursor = 0;
                } 
            
            //에딧 모드 끄기

        }//큰 이프 닫는애
        }    
        
        
        
        // 살짝 누른거 (버튼 2) 
        if (1 == flagUp) {
            flagUp = 0;
            pc.puts("Speed increase\n");
//            float tempVal = blinkSpeed[currentLED];
//            tempVal = tempVal - 0.1f;
//            if (tempVal < 0.1f) tempVal = 0.1f;
//            if (0 == currentLED) t3.attach(&BlinkLED1, tempVal);
//            else t4.attach(&BlinkLED2, tempVal);
//            blinkSpeed[currentLED] = tempVal;
        }     
        // 2초 이상 누른거 (버튼 2)
        else if (2 == flagUp) {
//            flagUp = 0;
//            blinkSpeed[currentLED] = 0.5;
//           if (0 == currentLED) t3.attach(&BlinkLED1, 0.5);
//            else t4.attach(&BlinkLED2, 0.5);
//            pc.puts(selLED[currentLED]);
            pc.puts(" : the speed is reset to 0.5s\n");
            
        }    
    wait(1);        // no wait() in While(); H.S.Lee
    

        
    
    }
    
}

// 버튼1을 2초 이상 누르면 LED 변환 (led1, led2 선택)
// 버튼2를 2초 이상 누르면 현재 LED 초기화 (초기 깜빡임 속도 0.5초)
// 버튼1을 살짝 누르면 깜빡임 속도 감소, 버튼2를 살짝 누르면 깜빡임 속도 증가 (0.1초 ~ 1초, 0.1초 단계)



