#include "mbed.h"

DigitalOut greenLed(LED1);
BusOut my7Seg(PA_8, PA_9, PA_10, PC_9, PC_8, PC_7, PC_6, PA_11);
//DigitalIn   exButton(PC_11);


DigitalOut  inLed(LED1);
DigitalOut  exLed(PA_12);
DigitalIn   inButton(PC_13);
DigitalIn   exButton(PC_11);


Serial pc(SERIAL_TX, SERIAL_RX);
//Serial pc(PA_2, PA_3);
//Serial pc(USBTX, USBRX);
 
DigitalOut myled(LED1);
 
void WriteData(int event)
{
    myled = !myled;
}
 
#define EX4
 
#ifdef   EX4
char rxData[4];
bool flagRx = 0;
 
void ReceiveInt()
{
    char inChar;
    static char rxCount = 0;
    static char rxBuf[4];
    
    while(1 == pc.readable()) {
        inChar = pc.getc();
        if ('<' == inChar)
        {
            rxCount = 1;            
        }
        else if (rxCount > 0 && rxCount < 5)
        {
            rxBuf[rxCount-1] = inChar;
            rxCount++;   
        }
        else if (5 == rxCount && '>' == inChar)
        {
            rxCount = 0;
            flagRx = 1;
            memcpy(rxData, rxBuf, 4);
//            myled = !myled;
//            pc.putc(rxData[0]);
//            pc.putc(rxData[1]);
//            pc.putc(rxData[2]);
//            pc.putc(rxData[3]);
 
//            pc.puts(rxData);  
        }
       
    }
}
 
 
int main()
{
    pc.baud(115200);
 
    pc.puts("\nStart!\n");    
    pc.printf("<LD01> : 0 ~ <LD15> : F\n");
    pc.attach(&ReceiveInt, Serial::RxIrq);      // RxIrq, TxIrq
//    pc.attach(&ReceiveInt);      // This operates same function like the above line
    
    char tmpCommand[3];
    int rxVal;
    my7Seg = 0xFF;
    greenLed = 1;
    
    int myseg;
    char temp7Seg;
    
    int n = 0;
    int preStatus = 0;
    float tempVal = 0;
    
    while(1)
    {
       if (1 == flagRx)
       {
            flagRx = 0;
            tmpCommand[0] = rxData[0];
            tmpCommand[1] = rxData[1];
            tmpCommand[2] = 0;
            rxVal = atoi(rxData+2);
            
            if (0 == strcmp(tmpCommand, "LD")) {

                pc.printf("val = %d\n", rxVal);
                n = rxVal;
                myled = (1 == rxVal)? 1:0;
//                myled = rxVal? 1:0;
            }
       }


        preStatus = exButton;
            
            switch(n) {
                case 0:
                    temp7Seg = ~0x3F;
                    break;
                case 1:
                    temp7Seg = ~0x06;
                    break;
                case 2:
                    temp7Seg = ~0x5B;
                    break;
                case 3:
                    temp7Seg = ~0x4F;
                    break;
                case 4: 
                    temp7Seg = ~0x66;
                    break;
                case 5: 
                    temp7Seg = ~0x6D;
                    break;
                case 6: 
                    temp7Seg = ~0x7D;
                    break;
                case 7:
                    temp7Seg = ~0x07;
                    break;
                case 8:
                    temp7Seg = ~0x7F;
                    break;
                case 9:
                    temp7Seg = ~0x6F;
                    break;
                case 10:
                    temp7Seg = ~0x77;
                    break;
                case 11:
                    temp7Seg = ~0x7C;
                    break;
                case 12:
                    temp7Seg = ~0x39;
                    break;
                case 13:
                    temp7Seg = ~0x5E;
                    break;
                case 14: 
                    temp7Seg = ~0x79;
                    break;
                case 15: 
                    temp7Seg = ~0x71;
                    break;


        }
        greenLed = !greenLed;
        my7Seg = (temp7Seg & 0x7F) | ((greenLed & 0x01)<<7);
            
        wait(0.25);
           
    }
}
 
#endif      // end of ex4





