#include "mbed.h"
#include "Adafruit_SSD1306.h"   // Adafruit_GFX library
#include "ADXL345.h"            // ADXL, SPI library

#define NUM_CHAR    16

#define OLED_DISPLAY
#define ADC_TEST

Serial      pc(SERIAL_TX, SERIAL_RX);
DigitalOut  greenLed(LED1);
DigitalOut  redLed(PA_12);
Timer       t1, t2;
Ticker       t3, t4;
InterruptIn   myButton(PC_13);
InterruptIn   exButton(PC_11);

BusOut my7Seg(PA_8, PA_9, PA_10, PC_9, PC_8, PC_7, PC_6, PA_11); // 8bit data
            // LSB,                                      , MSB

AnalogOut   myAnalogOut(PA_4);       
AnalogIn    lightSensor(PA_0);          
ADXL345     accelerometer(PB_5, PB_4, PB_3, PB_6);       // MOSI, MISO, SCK, CS

char    rxData[5];
bool    flagRx = 0;
int     dir = 1;        // 1: increase, -1: decrease
bool    flagT3 = 0;
bool    modeT3 = 0;     // 0: stop, 1: working
bool    flagDAC = 0;
bool    flagADC = 0;    
bool    flagADXL = 0;   // new added

void ReceiveInt() {
    char inChar;
    static char rxCount = 0;
    static char rxBuf[4];
    
    while(1 == pc.readable()) {
        inChar = pc.getc();
        if ('<' == inChar){
            rxCount = 1;            
        }
        else if (rxCount > 0 && rxCount < 5) {
            rxBuf[rxCount-1] = inChar;
            rxCount++;   
        }
        else if (5 == rxCount && '>' == inChar) {
            rxCount = 0;
            flagRx = 1;
            memcpy(rxData, rxBuf, 4);
//            pc.putc(rxData[0]);
//            pc.putc(rxData[1]);
//            pc.putc(rxData[2]);
//            pc.putc(rxData[3]);
 
//            pc.puts(rxData);  
        }
        else {
            rxCount = 0;
        }
    }
}

void tickerFunc3() {
    flagT3 = 1;
}

void Btn1Down() {
//    pc.puts("1 pushed\n");   // for debugging
    dir = -1*dir;
}

void Btn1Up() {
//    pc.puts("1 released\n");    // for debugging
    greenLed = !greenLed;
}

void Btn2Down() {
//    pc.puts("2 pushed\n");   // for debugging
    if (1 == modeT3) t3.detach();
    else t3.attach(tickerFunc3, 0.1);
    modeT3 = !modeT3;
}

void Btn2Up() {
//    pc.puts("2 released\n");    // for debugging
    redLed = !redLed;
}

void DACInt() {
    flagDAC = 1;
}

void ADCint() {
    flagADC = 1;
}

// new added
void ADXLInt()
{
    flagADXL = 1;
}

int main()
{   
    pc.baud(115200);
    pc.puts("\n<< ADXL Test Start>>\n");
    pc.printf("Device ID: 0x%02x\n", accelerometer.getDevId());      // 0xE5    
 
    pc.attach(&ReceiveInt, Serial::RxIrq);      // RxIrq, TxIrq
    myButton.fall(&Btn1Down);
    myButton.rise(&Btn1Up);
    exButton.fall(&Btn2Down);
    exButton.rise(&Btn2Up);
    
    myButton.disable_irq();     // to avoid unexpected interrupt
    exButton.disable_irq();     // to avoid unexpected interrupt
    
    //Go into standby mode to configure the device.
    accelerometer.setPowerControl(0x00);
     //Full resolution, +/-16g, 4mg/LSB.
    accelerometer.setDataFormatControl(0x0B);       // 0b 0000 1011
    //3.2kHz data rate.
    accelerometer.setDataRate(ADXL345_3200HZ);
    //Measurement mode.
    accelerometer.setPowerControl(0x08);        // 0b 0000 1000
    
    Ticker  tickerADXL;
    tickerADXL.attach(&ADXLInt, 0.05);
    

    I2C     I2C_Oled(PB_7, PA_15);       // SDA, SCL
    I2C_Oled.frequency(400000);     // 400kHz clock
    Adafruit_SSD1306_I2c    myOled(I2C_Oled, PD_2);    //  reset pin doesn't effect
//    Adafruit_SSD1306_I2c    myOled(I2C_Oled, PD_2, 64, 128);    //  make an error

    myOled.clearDisplay();  // clear buffer     
    myOled.printf("%u x %u OLED Display\r\n", myOled.width(), myOled.height());
    myOled.printf("Device ID: 0x%02x\n", accelerometer.getDevId());
    myOled.display();       // show a image on the OLED
    wait(1);

    myButton.enable_irq();     // enable IRQ
    exButton.enable_irq();     // enable IRQ
    
    time_t seconds = time(NULL);
    
    set_time(1617235200);  // Set RTC time to 2021-04-01, 00:00:00
    pc.printf("Time as a basic string = %s", ctime(&seconds));

    char buffer[32];
    strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
    pc.printf("1) Time as a custom formatted string = %s", buffer);
    strftime(buffer, 32, "%y-%m-%d, %H:%M:%S\n", localtime(&seconds));
    pc.printf("2) Time as a custom formatted string = %s", buffer);    

//    int preStatus1 = 0;
//    int preStatus2 = 0;
    int tempVal = 0;
    char tmpCommand[3];
    int rxVal;
    char    val7Seg[NUM_CHAR] = {0x3F, 0x06, 0x5B, 0x4F, 0x66, 0x6D, 0x7D, 0x07, 0x7F, 0x6F, 0x77, 0x7C, 0x39, 0x5E, 0x79, 0x71};

    modeT3 = 1;
    my7Seg = 0xFF;
      
    uint16_t n = 0;
    
    char tempVal2[10] = {0,};
    unsigned int    exLight;
    unsigned char   posY[2] = {0,};
    int     ADXLdata[3];    // new added
//    t3.attach(&tickerFunc3, 0.1);       // ticker3 start for display
    
    myOled.clearDisplay();  // clear buffer  

    while(1)
    {
        if (1 == flagT3) {
            flagT3 = 0;
            n = n + dir;
//            if (n > 200) n = 0;
//            myAnalogOut = n*0.005f;
//            sprintf(tempVal2, "%d, %1.2f\n", n, myAnalogOut.read());
//            pc.puts(tempVal2);
            
            my7Seg = ~val7Seg[n%16] & 0x7F;
            
            exLight = lightSensor.read() * 500;     // ADC read & send data : about 300us consume
            sprintf(tempVal2, "%d\n", exLight);
            pc.puts(tempVal2);
            
            #ifdef OLED_DISPLAY
            posY[1] = 64 - (unsigned char)((float)(exLight-300) * 0.512f);            // 128/1000 = 0.128
            myOled.drawLine(n, posY[0], n+1, posY[1], 1);
            myOled.display();                       // OLED display consumes about 28ms
            posY[0] = posY[1];
            if (n > 127) {
                n = 0;
                myOled.clearDisplay();
            }
            #endif
            
            greenLed = !greenLed;
        }
        
        if (1 == flagADXL) {
            flagADXL = 0;
            accelerometer.getOutput(ADXLdata);      // ADXL reading consumes about 80us
            pc.printf("%d, %d, %d\n", (int16_t)ADXLdata[0], (int16_t)ADXLdata[1], (int16_t)ADXLdata[2]);      // sending data consumes about 1ms (worst case)
            //pc.printf("%d\n",rxVal);

            if (rxVal == 1){
                //posY[1] = ADXLdata[0];            // 128/500 = 0.256
                posY[1] = 64 - (((float)ADXLdata[0]+200) * 0.032f);
                myOled.drawLine(n, posY[0], n+1, posY[1], 1);
                myOled.display();                       // OLED display consumes about 28ms
                posY[0] = posY[1];
                n++;
                if (n > 127) {
                    n = 0;
                    myOled.clearDisplay();
                }
            }

            if (rxVal == 2){
                //posY[1] = ADXLdata[1];            // 128/500 = 0.256
                posY[1] = 64 - (((float)ADXLdata[1]+200) * 0.032f);
                myOled.drawLine(n, posY[0], n+1, posY[1], 1);
                myOled.display();                       // OLED display consumes about 28ms
                posY[0] = posY[1];
                n++;
                if (n > 127) {
                    n = 0;
                    myOled.clearDisplay();
                }
            }


            if (rxVal == 3){
                //posY[1] = ADXLdata[2];            // 128/500 = 0.256
                posY[1] = 64 - ((float)ADXLdata[2] * 0.032f);
                myOled.drawLine(n, posY[0], n+1, posY[1], 1);
                myOled.display();                       // OLED display consumes about 28ms
                posY[0] = posY[1];
                n++;
                if (n > 127) {
                    n = 0;
                    myOled.clearDisplay();
                }
            } 
                
        if (rxVal == 0){
            myOled.clearDisplay();
        }
            
            
        }
        
        if (1 == flagRx){
            flagRx = 0;
            tmpCommand[0] = rxData[0];
            tmpCommand[1] = rxData[1];
            tmpCommand[2] = 0;
            rxVal = atoi(rxData+2);
            
            if (0 == strcmp(tmpCommand, "LD")) {        // control a LED
                pc.printf("val = %d\n", rxVal);
                
                greenLed = (1 == rxVal)? 1:0;
//                greenLed = rxVal? 1:0;
            }
            if (0 == strcmp(tmpCommand, "RE")) {        // reset all variables
                greenLed = 0;
                redLed = 1;
                n = 0;
            }
            if (0 == strcmp(tmpCommand, "OL"))
            {
                greenLed = 1;
                redLed = 1;
            }

    }
    }        
       
    
}
