#include "mbed.h"
#include "Adafruit_SSD1306.h"   // Adafruit_GFX library
#include "unist.h"

#define NUM_CHAR    16

Serial      pc(SERIAL_TX, SERIAL_RX);
DigitalOut  myled(LED1);
DigitalOut  redLed(PA_12);
Timer       t1, t2;
Ticker      t3, t4;
Ticker      ADCtimer;

InterruptIn   myButton(PC_13);
InterruptIn   exButton(PC_11);

BusOut my7Seg(PA_8, PA_9, PA_10, PC_9, PC_8, PC_7, PC_6, PA_11); // 8bit data
            // LSB,                                      , MSB

I2C     I2C_Oled(PB_7, PA_15);       // SDA, SCL
AnalogOut  myAnalogOut(PA_4);       // new added
AnalogIn lightSensor(PA_0);


char    rxData[5];
bool    flagRx = 0;
int     dir = 1;        // 1: increase, -1: decrease
bool    flagT3 = 0;
bool    modeT3 = 0;     // 0: stop, 1: working
bool    modeADC = 0;
bool    flagADC = 0;    // new added
const float samplingTime = 0.00005;

void GetADC(void)
{
    flagADC = 1;

}
void ReceiveInt() {
    char inChar;
    static char rxCount = 0;
    static char rxBuf[4];
    
    while(1 == pc.readable()) {
        inChar = pc.getc();
        if ('<' == inChar){
            rxCount = 1;            
        }
        else if (rxCount > 0 && rxCount < 5) {
            rxBuf[rxCount-1] = inChar;
            rxCount++;   
        }
        else if (5 == rxCount && '>' == inChar) {
            rxCount = 0;
            flagRx = 1;
            memcpy(rxData, rxBuf, 4);
//            pc.putc(rxData[0]);
//            pc.putc(rxData[1]);
//            pc.putc(rxData[2]);
//            pc.putc(rxData[3]);
 
//            pc.puts(rxData);  
        }
        else {
            rxCount = 0;
        }
    }
}

void tickerFunc3() {
    flagT3 = 1;
}

void Btn1Down() {
//    pc.puts("1 pushed\n");   // for debugging
    dir = -1*dir;
}

void Btn1Up() {
//    pc.puts("1 released\n");    // for debugging
    myled = !myled;
}

void Btn2Down() {
//    pc.puts("2 pushed\n");   // for debugging
    if (1 == modeT3) t3.detach();
    else t3.attach(tickerFunc3, 0.1);
    modeT3 = !modeT3;
}

void Btn2Up() {
//    pc.puts("2 released\n");    // for debugging
    redLed = !redLed;
}

// new added
void ADCInt()
{
    flagADC = 1;
}

// new added
int ADCcontrol(int val);


int main()
{   
    pc.baud(115200);
    pc.puts("\n<< ADC Test Start>>\n");    
 
    myButton.disable_irq();     // to avoid unexpected interrupt
    exButton.disable_irq();     // to avoid unexpected interrupt
    
    pc.attach(&ReceiveInt, Serial::RxIrq);      // RxIrq, TxIrq
    myButton.fall(&Btn1Down);
    myButton.rise(&Btn1Up);
    exButton.fall(&Btn2Down);
    exButton.rise(&Btn2Up);

    ADCtimer.attach(&GetADC, 0.01); // new added
    
    float exLight; // new added
    
    I2C_Oled.frequency(400000);     // 400kHz clock
//    Adafruit_SSD1306_I2c    myOled(I2C_Oled, PD_2, 0x78, 64, 128);    //  reset pin doesn't effect
//
//    myOled.clearDisplay();
//    myOled.drawBitmap(0, 0, unistLogo, 128, 64, 1);
//    myOled.display();
//    wait(1);  

    myButton.enable_irq();     // enable IRQ
    exButton.enable_irq();     // enable IRQ
    
    time_t seconds = time(NULL);
    
    set_time(1651121217);  // Set RTC time to 2022-4월-28, PM 1:46:57
    pc.printf("Time as a basic string = %s", ctime(&seconds));

    char buffer[32];
    strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
    pc.printf("1) Time as a custom formatted string = %s", buffer);
    strftime(buffer, 32, "%y-%m-%d, %H:%M:%S\n", localtime(&seconds));
    pc.printf("2) Time as a custom formatted string = %s", buffer);    

    char tmpCommand[3];
    int rxVal;
    char    val7Seg[NUM_CHAR] = {0x3F, 0x06, 0x5B, 0x4F, 0x66, 0x6D, 0x7D, 0x07, 0x7F, 0x6F, 0x77, 0x7C, 0x39, 0x5E, 0x79, 0x71};

    my7Seg = 0xFF;
      
    uint16_t n = 0;
    uint16_t k = 0;

    char tempVal2[10] = {0,};
    float tempVal3;

//    ADCtimer.attach(&ADCInt, samplingTime);      // 50us is appropriate for F303RE (20kHz)
    
    float soundFreq = 500;      // Hz
    pc.printf("smapling time = %dus, sound frequency = %dHz\n", (int)(samplingTime*1000000),   (int)soundFreq); 
       
    while(1)
    {
///////////////////////////////////////////////////////////////////
        if (1 == flagADC) {
            flagADC = 0;
            exLight = lightSensor.read()*3.3;
            myled = !myled;
            
            pc.printf("%f\n", exLight);
        }
    
        if (exLight > 2){
            myled = 0;
            redLed = 0;
        }
        else if (exLight < 0.5){
            myled = 1;
            redLed = 1;
        }
        else{
            myled = 0;
            redLed = 1;
        }
    
///////////////////////////////////////////////////////////////////

        if (exLight < 0.5){
            soundFreq = 400;
            }
        else if (exLight < 1){
            soundFreq = 800;
            }
        else{
            soundFreq = 2000;
            }


        if (1 == flagADC) {
            flagADC = 0;
            tempVal3 = soundFreq*n*samplingTime;
            myAnalogOut = 0.3*(sin(2*3.14159*tempVal3)*0.5+0.5);        // an angle is expressed in radians. 2*pi*f*t, 10~20 times amplication
            if (tempVal3 > 1.0f) n = 0;      // to prevent a phase shift due to overflow of the unsinged int variable
            n++;      
        }
        if (1 == flagT3) {
            flagT3 = 0;
            k = k + dir;
            tempVal3 = soundFreq*k*samplingTime*0.1f;       // general float calculation
//            tempVal3 = soundFreq*k*samplingTime*0.1;      // double precision calculation
            myAnalogOut = sin(2*3.14159*tempVal3)*0.5+0.5;        // 100 times slower
            sprintf(tempVal2, "%1.2f, %1.2f\n", tempVal3, myAnalogOut.read());
            pc.puts(tempVal2);

            if (tempVal3 > 1.0f) k = 0;      // to prevent a phase shift due to overflow of the unsinged int variable
            k++;      
        }
        
        if (1 == flagRx){
            flagRx = 0;
            tmpCommand[0] = rxData[0];
            tmpCommand[1] = rxData[1];
            tmpCommand[2] = 0;
            rxVal = atoi(rxData+2);
            
            if (0 == strcmp(tmpCommand, "LD")) {        // control a LED
                pc.printf("val = %d\n", rxVal);
                
                myled = (1 == rxVal)? 1:0;
//                myled = rxVal? 1:0;
            }
            else if (0 == strcmp(tmpCommand, "RE")) {        // reset all variables
                myled = 0;
                redLed = 1;
                n = 0;
                k = 0;
            }
            else if (0 == strcmp(tmpCommand, "DA")) {        // ADC control
                int tempVal;
                
                tempVal = ADCcontrol(rxVal);
                if (1 != tempVal) pc.puts(">> Wrong command\n");
                else my7Seg = ~val7Seg[rxVal%16] & 0x7F;                
            }
       }   
    }
}

int ADCcontrol(int val) {
    if (val<1 || val>2) return 0;
    switch (val) {
        case 1:     // sound out On/Off
            if (0 == modeADC) {
                modeADC = 1;
                
                // for 10kHz sine wave generation, it's needed to have 
                // a sampling frequency in 10 times of that frequency, 
                // or 100kHz -> 10us period
                ADCtimer.attach(&ADCInt, samplingTime);
                pc.puts(">> Sound On\n");
                }
            else {
                modeADC = 0;
                ADCtimer.detach();
                pc.puts(">> Sound Off\n");
                } 
            break;
        case 2:
            if (0 == modeT3) {
                modeT3 = 1;
                t3.attach(&tickerFunc3, 0.02);       // ticker3 start
                pc.puts(">> Plotting Start\n");
                }
            else {
                modeT3 = 0;
                t3.detach();
                pc.puts(">> Plotting Stop\n");
                }
            break;
        default:
            break;
    }
    return 1;
}
