#include "mbed.h"
#include "Adafruit_SSD1306.h"   // Adafruit_GFX library
#include "unist.h"

#define NUM_CHAR    16

Serial      pc(SERIAL_TX, SERIAL_RX);
DigitalOut  myled(LED1);
DigitalOut  redLed(PA_12);

Timer       t1, t2;
Ticker      t3, t4;
Ticker      DACtimer;

InterruptIn   myButton(PC_13);
InterruptIn   exButton(PC_11);

BusOut my7Seg(PA_8, PA_9, PA_10, PC_9, PC_8, PC_7, PC_6, PA_11); // 8bit data
            // LSB,                                      , MSB

I2C     I2C_Oled(PB_7, PA_15);       // SDA, SCL
AnalogOut  myAnalogOut(PA_4);       // new added
AnalogIn lightSensor(PA_0);

Ticker ADCtimer;
int flagADC;
char    rxData[5];
bool    flagRx = 0;
void GetADC(void)
{
    flagADC = 1;

}
void ReceiveInt() {
    char inChar;
    static char rxCount = 0;
    static char rxBuf[4];
    
    while(1 == pc.readable()) {
        inChar = pc.getc();
        if ('<' == inChar){
            rxCount = 1;            
        }
        else if (rxCount > 0 && rxCount < 5) {
            rxBuf[rxCount-1] = inChar;
            rxCount++;   
        }
        else if (5 == rxCount && '>' == inChar) {
            rxCount = 0;
            flagRx = 1;
            memcpy(rxData, rxBuf, 4);
//            pc.putc(rxData[0]);
//            pc.putc(rxData[1]);
//            pc.putc(rxData[2]);
//            pc.putc(rxData[3]);
 
//            pc.puts(rxData);  
        }
        else {
            rxCount = 0;
        }
    }
}
int main()
{
    pc.baud(115200);
    pc.attach(&ReceiveInt, Serial::RxIrq);      // RxIrq, TxIrq
    
    ADCtimer.attach(&GetADC, 0.01);
    
    
    pc.puts("\n<< ADC Test Start>>\n");
    
    float exLight;

    
    while(1)
    {
        if (1 == flagADC) {
            flagADC = 0;
            exLight = lightSensor.read()*3.3;
            myled = !myled;
            
            pc.printf("%f\n", exLight);
        }
    
        if (exLight > 2){
            myled = 0;
            redLed = 0;
        }
        else if (exLight < 0.5){
            myled = 1;
            redLed = 1;
        }
        else{
            myled = 0;
            redLed = 1;
        }
    
    }
    
}