#include "mbed.h"

LocalFileSystem local("local");
Serial pc(USBTX, USBRX);
Ticker timer; //interrupt to generate sine wave
DigitalOut low(LED1);
DigitalOut oc(LED2);
DigitalOut high(LED3);
AnalogIn level(p20);
AnalogOut sine_wave(p18);
PwmOut wave(p26);

float pulse_freq;
float pulse_period;
float pulse_width;
float sine_freq;
float sine_period;
float sine_amp;
float sine_vals[19], *sp, *last; //setup array for sine values, a pointer to access the array and one for the end of the array
void setup();
void sine();
void sine_table();

int main() {
    float a;
        
    FILE *fp=fopen("/local/setup.ini", "r");
    if(!fp) { 
        pulse_period=1; //default values if no .ini file
        pulse_width=0.5;
        sine_freq=1000;
        sine_amp=3.3; // peak to peak sine amplitude in V
        }
    else {
        fscanf(fp,"%f %f %f %f",&pulse_period, &pulse_width, &sine_freq, &sine_amp); //read values from .ini file
        fclose(fp);
        }
    wave.period(pulse_period);
    wave=pulse_width;
    sine_table(); //load sine values into table and start interrupt
    
    while(1) { //main loop
    a=level;
    low=(a<0.24); // light low led if voltage less then 0.8V
    high=(a>0.61); // light high led if voltage greater than 2V
    oc=(a>=0.24 && a<=0.61); //light oc LED if open circuit or indeterminate level
    if (pc.readable()) setup(); //if PC keyboard pressed setup waveforms via pc 
    }
 }

void setup() { //function to get waveform values from pc
    printf("\f\n Pulse Frequency (0.1-1000000Hz):- \n");
    scanf("%f",&pulse_freq);
    if (pulse_freq>1000000) pulse_freq=1000000;
    if (pulse_freq<0.1) pulse_freq=0.1;
    pulse_period=1/pulse_freq;
    printf("\n Pulse Width (0.1-0.9):- \n");
    scanf("%f",&pulse_width);
    if (pulse_width>0.9) pulse_width=0.9;
    if (pulse_width<0.1) pulse_width=0.1;
    printf("\n Sine Frequency (0.1-1000Hz):- \n");
    scanf("%f",&sine_freq);
    if (sine_freq>1000) sine_freq=1000;
    if (sine_freq<0.1) sine_freq=0.1;
    printf("\n Sine Amplitude (0-3.3V p/p):- \n");
    scanf("%f",&sine_amp);
    if (sine_amp>3.3) sine_amp=3.3;
    if (sine_amp<0) sine_amp=0;
    printf("\n\n Pulse Frequency %f Hz \n Pulse Width %f \n",pulse_freq, pulse_width);
    printf("\n Sine Frequency %f Hz \n Sine Amplitude %f V \n",sine_freq, sine_amp); 
    FILE *fp=fopen("/local/setup.ini","w"); // save values on flash drive
    fprintf(fp,"%f %f %f %f",pulse_period,pulse_width,sine_freq,sine_amp);
    fclose(fp);
    wave.period(pulse_period); //start PWM output
    wave=pulse_width;
    sine_table(); // load new values into sine table and start interrupt
}

void sine_table() { // function to load sine values into array and start interrupt
    float *p, i;
    
    sine_amp=sine_amp/3.3; //convert from p/p voltage to percentage
    p=sine_vals; //set p to point to beginning of array
    sp=p; //set sp also
    for (i=0;i<3;i+=0.15707965) {
        *p=sine_amp*sin(i);
        p++;
        }
    last=p-1; //last element in array

    sine_period=(1000000/sine_freq)/19; // period between calling sine routine
    timer.attach_us(&sine,sine_period); // start the interrupt
}
    
void sine() { // function to output sine wave to analogue output

    if (sp>last) sp=sine_vals; //if at end of array reset sp back to beginning
    sine_wave.write(*sp);
    sp++;
} 
