#include "mbed.h"
#include "LEDManager.h"

Timer timer;
Serial pc(USBTX,USBRX/*,921600*/);


LEDManager *l1g = new LEDManager(D11,10000);
LEDManager *l1b = new LEDManager(D4,10000);
LEDManager *l1r = new LEDManager(D7,10000);
LEDManager *l2r = new LEDManager(D5,10000);
LEDManager *l2g = new LEDManager(D6,10000);
LEDManager *l2b = new LEDManager(D12,10000);
LEDManager *l3r = new LEDManager(D8,10000);
LEDManager *l3g = new LEDManager(D9,10000);
LEDManager *l3b = new LEDManager(D10,10000);

int main() 
{
    pc.printf("Starting...\n");
    
    printf("Test procedure\n");
    
    timer.start();
    
  
    int time = timer.read_us();
    
    DigitalIn button(USER_BUTTON);
    
    
    while(1)
    {
        time = timer.read_us();
        
        l1g->processLED(time);
        l1b->processLED(time);
        l1r->processLED(time);
        l2r->processLED(time);
        l2g->processLED(time);
        l2b->processLED(time);
        l3r->processLED(time);
        l3g->processLED(time);
        l3b->processLED(time);
        
        if(button == 0){
            l1g->setFadeUpdatePeriod(l1g->getFadeUpdatePeriod() + 1000);
            l2g->setFadeUpdatePeriod(l2g->getFadeUpdatePeriod() + 1000);
            l3g->setFadeUpdatePeriod(l3g->getFadeUpdatePeriod() + 1000);
            
            l1b->setFadeUpdatePeriod(l1b->getFadeUpdatePeriod() + 1500);
            l2b->setFadeUpdatePeriod(l2b->getFadeUpdatePeriod() + 1500);
            l3b->setFadeUpdatePeriod(l3b->getFadeUpdatePeriod() + 1500);
            
            l3r->setActive(!l3r->getActiveness());
            while(button != 1);       
        }
        
        
                
    }
}


