#ifndef LEDMANAGER_H
#define LEDMANAGER_H

#include "mbed.h"

class LEDManager
{
    public:
        LEDManager(PinName pin, int period_us)
        {
            this->io = new DigitalOut(pin);
            this->period_us = period_us;
            this->prevUpdate = 0;
            this->highTime = this->period_us*0.5;
            this->lowTime = this->period_us - this->highTime;
            this->fadeFactor = 100;
            this->situation = 1;
            this->fadeUpdatePeriod = 40000;   
            this->prevFadeUpdate = 0;
            this->isActive = true;
        }
        
        LEDManager(DigitalOut *io, int period_us)
        {
            this->io = io;
            this->period_us = period_us;
            this->prevUpdate = 0;
            this->highTime = this->period_us*0.5;
            this->lowTime = this->period_us - this->highTime;
            this->fadeFactor = 100;
            this->situation = 1;
            this->fadeUpdatePeriod = 10000;   
        }
        
        void processLED(int time)
        {
            if(!this->isActive)
            {
                return;   
            }
            if(situation == 1){
                if((time - prevUpdate) < highTime){
                    io->write(1);
                }
                else{
                    situation = 2;
                    prevUpdate = time;
                }
            }
            if(situation == 2){
                if((time - prevUpdate) < lowTime){
                    io->write(0);
                } 
                else{
                    situation = 1;   
                    prevUpdate = time;
                }  
            }
            
            
            if(time - prevFadeUpdate > fadeUpdatePeriod){
                highTime = highTime + fadeFactor;
                lowTime = period_us - highTime;
                if(highTime >= period_us){
                    fadeFactor = -fadeFactor;   
                }
                else if(highTime <= 0){
                    fadeFactor = -fadeFactor;
                }
                prevFadeUpdate = time;
            }
        }
        
        void setFadeUpdatePeriod(int period){ this->fadeUpdatePeriod = period;}
        int getFadeUpdatePeriod(){ return this->fadeUpdatePeriod;}
        void setFadeFactor(int fadeFactor){ this->fadeFactor = fadeFactor;}
        int getFadeFactor(){ return this->fadeFactor;}
        int getHighTime(){ return this->highTime;}
        void setActive(bool state){ this->isActive = state;}
        bool getActiveness(){ return this->isActive;}
        
        
    private:
        DigitalOut *io;
        int period_us;
        int prevUpdate;
        int highTime;
        int lowTime;
        int situation;
        
        int prevFadeUpdate;
        int fadeFactor;
        int fadeUpdatePeriod;
        bool isActive;
};

#endif
