#ifndef __BLE_DHT11_SERVICE_H__
#define __BLE_DHT11_SERVICE_H__


class DHT11Service {
public:
    const static uint16_t DHT11_UUID              = 0xA100;//False UUID does not exists
    const static uint16_t TEMPERATURE_CHARACTERISTIC_UUID = 0x2A6E;
    const static uint16_t HUMIDITY_CHARACTERISTIC_UUID = 0x2A6F;

    DHT11Service(BLEDevice &_ble, uint8_t initialTempValue, uint8_t initialHumiValue) :
        ble(_ble), 
        /*temperatureValue(TEMPERATURE_CHARACTERISTIC_UUID,&initialTempValue),*/
        temperatureValue(TEMPERATURE_CHARACTERISTIC_UUID, 
            &initialTempValue,
            sizeof(uint8_t),
            sizeof(uint8_t),
            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
        humidityValue(HUMIDITY_CHARACTERISTIC_UUID, 
            &initialHumiValue,
            sizeof(uint8_t),
            sizeof(uint8_t),
            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
        /*humidityValue(HUMIDITY_CHARACTERISTIC_UUID,&initialHumiValue)*/
    {
        GattCharacteristic *charTable[] = {&temperatureValue,&humidityValue};
        GattService service(DHT11_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(service);
        
    }

    GattAttribute::Handle_t getValueHandle() const {
        return temperatureValue.getValueHandle();
    }
    
    void updateTemperatureValue(uint8_t value) {
        ble.gattServer().write(temperatureValue.getValueHandle(), (uint8_t *)&value, sizeof(uint8_t));
    }
    void updateHumidityValue(uint8_t value) {
        ble.gattServer().write(humidityValue.getValueHandle(), (uint8_t *)&value, sizeof(uint8_t));
    }

private:
    BLEDevice                         &ble;
    GattCharacteristic temperatureValue;
    GattCharacteristic humidityValue;
};

#endif
