/*
Tested with a STM32 L476 and the IDB05A1 BLE shield
*/

#include "mbed.h"
#include "ble/BLE.h"
#include "DHT11_BLEService.h"
#include "DHT11.h"

DigitalOut LED(LED1, 0);

const static char     DEVICE_NAME[] = "DHT11";
static const uint16_t uuid16_list[] = {DHT11Service::DHT11_UUID};

DHT11Service *dht11ServicePtr;//Bluetooth service that manage information and ble updates
uint8_t tempValue;
uint8_t humiValue;

DHT11 dht11(PC_10);//Data pin of the DTH11 sensor
Ticker updateTick;

void updateData(){
        //LED = 1;
        if(!dht11.readData()){
           for(int i = 0; i < 10; i++){LED = !LED; wait_ms(50);}
        }
        dht11ServicePtr->updateTemperatureValue(dht11.getTemperature());
        dht11ServicePtr->updateHumidityValue(dht11.getHumidity());
        //LED = 0;
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    (void)params;
    BLE::Instance().gap().startAdvertising(); // restart advertising
}

/**
 * This callback allows the LEDService to receive updates to the ledState Characteristic.
 *
 * @param[in] params
 *     Information about the characterisitc being updated.
 */
/*void onDataWrittenCallback(const GattWriteCallbackParams *params) {
    if ((params->handle == ledServicePtr->getValueHandle()) && (params->len == 1)) {
        actuatedLED = *(params->data);
    }
}*/

/** 
 * This function is called when the ble initialization process has failled 
 */ 
void onBleInitError(BLE &ble, ble_error_t error) 
{ 
    /* Initialization error handling should go here */ 
} 

/** 
 * Callback triggered when the ble initialization process has finished 
 */ 
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params) 
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {
        /* In case of error, forward the error handling to onBleInitError */
        onBleInitError(ble, error);
        return;
    }

    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }

    ble.gap().onDisconnection(disconnectionCallback);
    //ble.gattServer().onDataWritten(onDataWrittenCallback);

    tempValue = 20;
    humiValue = 10;
    dht11ServicePtr = new DHT11Service(ble, tempValue,humiValue);
    
    updateTick.attach(&updateData,5.0);
    
    /* setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(1000); /* 1000ms. */
    ble.gap().startAdvertising();

    while (true) {
        ble.waitForEvent();
    }
}


int main(void)
{
    BLE &ble = BLE::Instance();
    
    ble.init(bleInitComplete);
}

