#include "ADXL345_I2C.h"

 ADXL345_I2C accelerometer(D14, D15);
 Serial pc(USBTX, USBRX);
 
 DigitalIn button(USER_BUTTON);

 int main() {
       pc.baud(115200);
     int16_t readings[3] = {0, 0, 0};
     
     pc.printf("Starting ADXL345 test...\n");
     wait(.001);
     pc.printf("Device ID is: 0x%02x\n", accelerometer.getDeviceID());
    wait(.001);
    
     // These are here to test whether any of the initialization fails. It will print the failure
    if (accelerometer.setPowerControl(0x00)){
         pc.printf("didn't intitialize power control\n"); 
         return 0;  }
     //Full resolution, +/-16g, 4mg/LSB.
     wait(.001);
     
     if(accelerometer.setDataFormatControl(0x0B)){
        pc.printf("didn't set data format\n");
        return 0;  }
     wait(.001);
     
     //3.2kHz data rate.
     if(accelerometer.setDataRate(ADXL345_3200HZ)){
        pc.printf("didn't set data rate\n");
        return 0;    }
     wait(.001);
     
     //Measurement mode.
     
     if(accelerometer.setPowerControl(MeasurementMode)) {
        pc.printf("didn't set the power control to measurement\n"); 
        return 0;   } 
    int nbPoints = 0;
     while (1) {
        
        
        if(button != 0){
            while(nbPoints < 3*10){
                wait(0.1);
                accelerometer.getOutput(readings);
                pc.printf("%d,%d,%d,\n",readings[0],readings[1],readings[2]);
                //pc.printf("%f,%f,%f,", (float)((int16_t)readings[0]+1000)/2000.0, (float)((int16_t)readings[1]+1000)/2000.0, (float)((int16_t)readings[2]+1000)/2000.0);
                
                nbPoints += 3;
            }
            nbPoints = 0;
            printf("\n");
        }
     }
 
 }
