

//#include "EthernetInterface.h"
#include <stdlib.h>
#include <string.h>
#include "mbed.h"
#include "rtos.h" // need for main thread sleep
#include "html.h" // need for html patch working with web server
#include "bloc_io.h"
#define RADIUS  0.2F // wheel size
#define NBPOLES 8 // magnetic pole number
#define DELTA_T 0.1F // speed measurement counting period
#define AUTO 0  //definition des valeurs pour les differents modes
#define MANUEL 1
#define DT 0.2
#define pi 3.14159
#define POLE 8
#define RAYON 0.19
#define TICKER_PROGRESSIF 0.05
#define TICKER_TENSION_BATTERIE 0.2
#define TICKER_TENSION_TEMPERATURE 0.2
#define TEMP_MAX 373
#define TENSION_BAT_MAX 30
#define TENSION_BAT_MIN 20
#define TENSION_TEMP_MAX 3.73
#define BAT_MAX 0.386
#define TICKER_TENSION_COURANT 0.2
#define RESISTANCE_EQUIVALENTE 0.5409836
#define PENTE_CAPTEUR_COURANT 0.185
#define TENSION_CPT_COURANT_MIN 2.505

Bloc_IO MyPLD(p25,p26,p5,p6,p7,p8,p9,p10,p23,p24);// instantiate object needed to communicate with PLD
// analog input connected to mbed
Serial pc(USBTX, USBRX); // tx, rx
// Top_Hall Pin




/************ persistent file parameters section *****************/
LocalFileSystem local("local");               // Create the local filesystem under the name "local"







/********************* web server section **********************************/

var_field_t tab_balise[10];  //une balise est présente dans le squelette
int iCounter=0;// acces counting


/*********************** can bus section  ************/
// determine message ID used to send Gaz ref over can bus
#define _CAN_DEBUG // used to debug can bus activity
//#define USE_CAN_REF // uncomment to receive gaz ref over can_bus
CAN can_port (p30, p29); // initialisation du Bus CAN sur les broches 30 (rd) et 29(td) for lpc1768 + mbed shield
bool bCan_Active=false;



DigitalOut led1(LED1); //initialisation des Leds présentes sur le micro-controleur Mbed*/
DigitalOut led2(LED2);
DigitalOut led3(LED3); // blink when can message is sent
DigitalOut led4(LED4); // blink when can message is received
DigitalOut valid_pwm(p21);
AnalogIn Vgaz(p17);
Ticker COMMANDE;
Ticker VITESSE;
Ticker GAZ;
Ticker TENSION_BATTERIE;
Ticker TENSION_TEMPERATURE;
Ticker TENSION_COURANT;
InterruptIn valid(p22);
AnalogIn Vbat(p18);
AnalogIn Vtemp(p19);
AnalogIn Vcourant(p20);


//************ local function prototypes *******************
void commande_gaz();  //fonction de commande des gaz par la poignée
void cpt_vit();
void calc_vit();
void acceleration_progressive();
void tension_batterie();
void tension_temperature();
void tension_courant();



//*************************Variable globale********************************************************/
float Nmin,Nmax,Ngaz,fVbat,fTension,Puissance_Gaz,fTemperature,fVtemp,fCourant,fVcourant;
int iREF_PWM_MANUEL_BRUT;
int iREF_PWM_AUTO_BRUT,iREF_PWM_AUTO_FINALE;
int imode;
int ireg;
int iHALL,iBRAKE,iFALT,iOC,iDIR;
int iLim_vit;
float fv,fcpt,fnbr_poles;

/**************** Read persistent data from text file located on local file system ****************/



/**************** write persitant  data to text file located on local file system ****************/






//************** calibation gaz function needed to record min_gaz and max_gaz value to persistent text file  ******************


// ************top hall counting interrupt needed for speed measurement


//********************** timer interrupt for speed measurement each 100ms  *************************






//********************* Timer Interrupt for gaz ref management each 10ms   ********************



/********* main cgi function used to patch data to the web server thread **********************************/
void CGI_Function(void) // cgi function that patch web data to empty web page

{ char ma_chaine4[20]={};// needed to form html response
sprintf (ma_chaine4,"%d",iCounter);// convert speed as ascii string
Html_Patch (tab_balise,0,ma_chaine4);// patch first label with dyn.string
iCounter++;
}


/*********************** CAN BUS SECTION  **********************/



void CAN_REC_THREAD(void const *args)
{
    int iCount,iError;

    while (bCan_Active) {
        Thread::wait(100);// wait 100ms
        // code todo

    }

}



//*************************** main function *****************************************
int main()
{
    
    
    char cChoix=0;
    char cCalibre=0;
    char cRegistre=0;
    char cVitesse=0;
    char cAlim=0;
    valid_pwm.write(0);
    iREF_PWM_MANUEL_BRUT=0;
    iREF_PWM_AUTO_BRUT=0;
    iREF_PWM_AUTO_FINALE=0;
    // limite de vitesse en m/h par défaut


    valid.mode(PullUp);
    MyPLD.write(0);
    valid_pwm.write(1);
    imode=AUTO;  //mode d'initialisation = AUTO
    FILE *fp = fopen("/local/scoot.txt", "r");
    if(fp!= NULL) {
        fscanf(fp,"%f %f %d",&Nmin,&Nmax,&iLim_vit);
        fclose(fp);
    } else {
        pc.printf("fichier non ouvert\n\r");
        fclose(fp);
    }
    /*Nmax=0.5;
    Nmin=0.3;*/
   
//***************************************** web section ********************************************/
    pc.printf("\n\r");
    pc.printf("searching broadcast...\n\r");
    pc.printf("wait...\n\r");
    Init_Web_Server(&CGI_Function); // create and initialize tcp server socket and pass function pointer to local CGI function
    Thread WebThread(Web_Server_Thread);// create and launch web server thread
    Gen_HtmlCode_From_File("/local/pagecgi2.htm",tab_balise,1);// read and localise ^VARDEF[X] tag in empty html file
    /********* main cgi function used to patch data to the web server thread **********************************/
    

//******************************************* end web section  ************************************* /
    COMMANDE.attach(&commande_gaz,0.1);
    valid.rise(&cpt_vit);
    VITESSE.attach(&calc_vit,DT);
    GAZ.attach(&acceleration_progressive,TICKER_PROGRESSIF);
    TENSION_BATTERIE.attach(&tension_batterie,TICKER_TENSION_BATTERIE );
    TENSION_TEMPERATURE.attach(&tension_temperature,TICKER_TENSION_TEMPERATURE);
    TENSION_COURANT.attach(&tension_courant,TICKER_TENSION_COURANT);



    pc.printf(" programme scooter mbed \n\r");



//********************* can bus section initialisation *******************************************
//bCan_Active=true;// needed to lauchn CAN thread
//Thread CanThread(CAN_REC_THREAD);// create and launch can receiver  thread
//********************* end can bus section *****************************************************


    while(cChoix!='q' and cChoix!='Q')

    {
        pc.printf(" veuillez saisir un choix parmi la liste proposee: \n\r");
        pc.printf(" 1:lecture poignée gaz\n\r");
        pc.printf(" 2:lecture courant\n\r");
        pc.printf(" 3:parametre batterie\n\r");
        pc.printf(" 4:lecture temperature\n\r");
        pc.printf(" 5:parametres vitesse\n\r");
        pc.printf(" 6:lecture pe\n\r");
        pc.printf(" 7:parametres Nmin,Nmax\n\r");
        pc.printf(" 8:saisir PWM (0 a 255)\n\r");
        pc.printf(" 9:lecture du registre\n\r");
        pc.printf(" q:quitter \n");
        pc.printf(" mode=%d\n\r",imode);
        cRegistre=0;
        cCalibre=0;
        cVitesse=0;
        cAlim=0;
        valid_pwm.write(1);
        /************* multithreading : main thread need to sleep in order to allow web response */
        while (pc.readable()==0) { // determine if char availabler
            Thread::wait(10);   // wait 10 until char available on serial input
        }
        /************* end of main thread sleep  ****************/

        pc.scanf(" %c",&cChoix);
        switch (cChoix) {
            case '1':
                pc.printf("poignee = %f\n\r",Ngaz);
                break;
            case '2':
                break;
            case '3':
                while(cAlim!='q') {
                    pc.printf("1:lecture tension batterie\n\r");
                    pc.printf("2:lecture courant batterie\n\r");
                    pc.printf("3:lecture temperature batterie\n\r");
                    pc.printf("q:menu principal\n\r");
                    pc.scanf(" %c",&cAlim);
                    switch(cAlim) {
                        case '1':
                            pc.printf("tension batterie : %f V\n\r",fTension);
                            break;
                        case '2':
                            pc.printf("courant mesure : %f A\n\r",fCourant);
                            break;
                        case '3':
                            pc.printf("temperature batterie :%f °C\n\r",fTemperature);
                            break;
                    }
                }

                break;
            case '4':
                break;
            case '5':
                while(cVitesse!='q') {
                    pc.printf("1:lecture vitesse en m/s\n\r");
                    pc.printf("2:lecture vitesse en m/h\n\r");
                    pc.printf("3:lecture vitesse en km/h\n\r");
                    pc.printf("4:limite de vitesse = %d , redefinir ?\n\r",iLim_vit);
                    pc.printf("q:menu principal\n\r");
                    pc.scanf("%c",&cVitesse);
                    switch(cVitesse) {
                        case '1':
                            pc.printf("%f m/s\n\r",fv);
                            break;
                        case '2':
                            pc.printf("%f m/h\n\r",fv*3600);
                            break;
                        case '3':
                            pc.printf("%f km/h\n\r",fv*3.6);
                            break;
                        case'4':
                            pc.printf("choisir limite : ");
                            pc.scanf("%d",&iLim_vit);

                    }
                }
                break;
            case '6':
                break;
            case '7':
                valid_pwm.write(0);
                while(cCalibre!='q') {
                    pc.printf("1:definir Nmin ? mettre poignee au min puis saisir 1\n\r");
                    pc.printf("2:definir Nmax ? mettre poignee au max puis saisir 2\n\r");
                    pc.printf("3:lecture Nmin,Nmax\n\r");
                    pc.printf("q:menu principal\n\r");
                    pc.scanf("%c",&cCalibre);

                    switch(cCalibre) {
                        case '1':
                            Nmin=Ngaz;
                            pc.printf("Nmin = %f\n\r",Nmin);
                            break;
                        case '2':
                            Nmax=Ngaz;
                            pc.printf("Nmax = %f\n\r",Nmax);
                            break;
                        case '3':
                            pc.printf("Nmin=%f\n\r",Nmin);
                            pc.printf("Nmax=%f\n\r",Nmax);
                            pc.printf("puissance=%f %%\n\r",Puissance_Gaz);
                            break;
                    }
                }


                break;
            case '8':
                pc.printf("choisir pwm :");
                pc.scanf("%d",&iREF_PWM_MANUEL_BRUT);
                if(iREF_PWM_MANUEL_BRUT>255) {
                    iREF_PWM_MANUEL_BRUT=0;
                }
                pc.printf("%d\n\r",iREF_PWM_MANUEL_BRUT);

                break;
            case '9':
                while(cRegistre!='q') {
                    pc.printf("1:lecture registre\n\r");
                    pc.printf("q:quitter\n\r");
                    pc.scanf(" %c",&cRegistre);

                    switch(cRegistre) {
                        case'1':
                            ireg=MyPLD.read();
                            iHALL=ireg & 0x07;
                            iBRAKE=ireg & 0x20;
                            iDIR=ireg & 0x08;
                            iFALT=ireg & 0x10;
                            iOC=ireg & 0x40;
                            pc.printf("secteur = %d\n\r",iHALL);
                            if(iBRAKE==0) {
                                pc.printf(" frein actif\n\r");
                            }
                            if(iBRAKE==32) {
                                pc.printf(" frein inactif\n\r");
                            }
                            if(iDIR==8) {
                                pc.printf(" marche avant\n\r");
                            }
                            if(iDIR==0) {
                                pc.printf(" marche arriere\n\r");
                            }
                            if(iFALT==16) {
                                pc.printf(" erreur\n\r");
                            }
                            if(iFALT==0) {
                                pc.printf(" pas d'erreur\n\r");
                            }
                            if(iOC==0) {
                                pc.printf(" surtension\n\r");
                            }
                            if(iOC==64) {
                                pc.printf(" tension normale\n\r");
                            }



                            break;

                    }
                }

                break;
            case 'a':
                imode=AUTO;    //mis en mode AUTO
                break;
            case 'm':
                imode=MANUEL;    //mis en mode AUTO
                break;

            case 'q':
                MyPLD.write(0);
                valid_pwm=0;
                COMMANDE.detach();
                VITESSE.detach();
                GAZ.detach();
                FILE *fp=fopen("/local/scoot.txt", "w");
                if(fp!= NULL) {
                    fprintf(fp,"%f %f %d",Nmin,Nmax,iLim_vit);
                    fclose(fp);
                } else {
                    pc.printf("fichier non ouvert\n\r");
                    fclose(fp);
                } //'arret du scooter'
                break;
        }
    } // end while

    //************** thread deinit *********************
    //bCan_Active=false;
    //CanThread=false;// close can received thread
    pc.printf(" fin programme scooter mbed \n\r");
    DeInit_Web_Server() ;// disable web server thread
} // end main
void commande_gaz()
{
    Ngaz=Vgaz.read();
    iREF_PWM_AUTO_BRUT=255*(Ngaz-Nmin)/(Nmax-Nmin);
    if(iREF_PWM_AUTO_BRUT<0) {
        iREF_PWM_AUTO_BRUT=0;
    }
    if(iREF_PWM_AUTO_BRUT>255) {
        iREF_PWM_AUTO_BRUT=255;
    }
    if ( imode==MANUEL) {
        MyPLD.write(iREF_PWM_MANUEL_BRUT);
    } else {
        MyPLD.write(iREF_PWM_AUTO_FINALE);
    }
    if(Puissance_Gaz>=0 && Puissance_Gaz<=100) {
        Puissance_Gaz=(Ngaz-Nmin)/(Nmax-Nmin)*100;
    }
    if(Puissance_Gaz>100) {
        Puissance_Gaz=100;
    }
    if(Puissance_Gaz<0) {
        Puissance_Gaz=0;
    }

}
void cpt_vit()
{
    fcpt++;
}
void calc_vit()
{
    fnbr_poles=fcpt;
    fv=(fnbr_poles*2*pi*RAYON)/(6*POLE*DT);
    fcpt=0;

}
void acceleration_progressive()
{
    ireg=MyPLD.read();
    iBRAKE=ireg & 0x20; //lecture du frein
    if(iBRAKE==0) {
        iREF_PWM_AUTO_FINALE = 0;
    } else {
        if(fv*3600>iLim_vit) {
            if(iREF_PWM_AUTO_FINALE>0) {
                iREF_PWM_AUTO_FINALE--;
            } else {
                iREF_PWM_AUTO_FINALE=0;
            }
        } else {

            if(iREF_PWM_AUTO_FINALE<iREF_PWM_AUTO_BRUT) {

                iREF_PWM_AUTO_FINALE++;
            } else {
                iREF_PWM_AUTO_FINALE=iREF_PWM_AUTO_BRUT;
            }
        }
    }
}
void tension_batterie()
{
    fVbat=Vbat.read();
    fTension=fVbat/BAT_MAX*TENSION_BAT_MAX;
}
void tension_temperature()
{
    fVtemp=Vtemp.read();
    fTemperature=fVtemp*3.3/TENSION_TEMP_MAX*TEMP_MAX-273;
}
void tension_courant()
{
    fVcourant=Vcourant.read()*3.3/RESISTANCE_EQUIVALENTE;
    fCourant=(fVcourant-TENSION_CPT_COURANT_MIN)/PENTE_CAPTEUR_COURANT;
}