// main.cpp

//To Do:
// * USB device detect
// * Ability to update binary from the thumb-drive (requires file timestamp)
// * Audible friction brake feedback
// * User-configurable watchpoint
// * Add 50% charge option
// * Tire Pressure Sensor display
// * Fix bug in playback while connected to canbus (hangs)
// * Add temperature to Main screen

#include "mbed.h"
#include "CAN.h"
#include "beep.h"
#include "MSCFileSystem.h"
#include "PowerControl.h"
#include "EthernetPowerControl.h"
#include "utility.h"
#include "displayModes.h"
#include "TOUCH_TFTx2.h"

LocalFileSystem local("local");

// to write to USB Flash Drives, or equivalent (SD card in Reader/Writer)
MSCFileSystem fs("usb"); // to write to a USB Flash Drive

time_t seconds ;

Ticker autoPoll;
Ticker playback;
Ticker msgReq;
Timer timer;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

InterruptIn touchpad(p17);
CAN can1(p9, p10);      // CAN1 (EV) uses pins 9 and 10 (rx, tx) and pin 8 (rs)
DigitalOut can1SleepMode(p8);     // Use pin 8 to control the sleep mode of can2
CAN can2(p30, p29);     // CAN2 (CAR) uses pins 30 and 29 (rx, tx) and pin 28 (rs)
DigitalOut can2SleepMode(p28);     // Use pin 28 to control the sleep mode of can1
AnalogIn mon12V(p15);
TOUCH_TFTx2 tt(p16, p17, p19, p20, p11, p12, p13, p6, p7, p5, "TFT"); // x+,x-,y+,y-,mosi, miso, sclk, cs0, cs1, reset
PwmOut dled(p23);
Beep spkr(p21);

// revision string, max 6 characters
// gg - revStr is used in 2 places
// gg - and is easy to edit here
// gg - added ZeroSecTick and revStr
char revStr[7] = "97";

bool debugMode = false;
bool logEn = false, logOpen = false; 
bool yesBattLog = false ; // gg - Batt Log
unsigned char tNavRow = 3 ; // gg - 4x4 touch

FILE *cfile;
FILE *file;
char fileName[35] = "" ;
char writeBuffer[maxBufLen][13] __attribute__ ((section("AHBSRAM1"))); // buffer for USB write
char indexLastMsg[0x800]={0}; // index table for last message
CANMessage lastMsg[100]; // table to store last message of eachtype

//unsigned char battData[256]={0}; // 7 * 0x3D = BatDataBufMax
unsigned char battData[BatDataBufMax]={0}; // 7 * 0x3D = BatDataBufMax

unsigned char msgChanged[100]; // inidcates which bytes changed
char c;
volatile int writePointer = 0;
int readPointer=0;
volatile unsigned short secsNoMsg = 0;
volatile unsigned short secsNoTouch = 0;
volatile bool canIdle;
volatile bool userIdle;
bool touched=false; //flag to read touchscreen
unsigned char whichTouched = 0;
char counter = 0;
unsigned char dMode[2] = {mainScreen,brakeScreen}; //display mode
unsigned char sMode = 0; // setup mode
unsigned char lastDMode[2] = {0,0}; //last screen mode
unsigned char dtMode = 6;
char displayLog[20][40];
unsigned char displayLoc = 0;
unsigned int fwCount=1;
unsigned char indexOffset = 1;
bool showCP = false;
//bool pollCP = false;
bool logCP = false; //Turbo3
bool repeatPoll = false;
bool headlights = false;
bool tick = false;
bool ZeroSecTick = false;
float ledHi = 0.8; // Bright LED value (until config file read)
float ledLo = 0.1; // Dim LED value (until config file read)
unsigned short pollInt = 300; // polling interval=5 minutes (until config file read)
bool accOn = false; // Accessories on
bool laccOn = false;
float scale12V = 16.2; // R1:R2 ratio
signed long mWs_x4 = 0;
unsigned short numWsamples = 0;
unsigned short numSsamples = 0;
float accV = 0;
bool playbackEn = false;
bool playbackOpen = false;
//float playbackInt = 0.05; //read messages every 50 ms
float playbackInt = 0.005; //read messages every 5 ms
bool step = false;
char header[5];
char data[8];
signed long motorRPM;
unsigned char skin = ttSkin ;
unsigned char dtePeriod = 14; //ten minute averaging interval
float mph[39]={0};
float kW[39]={0};
float mpkWh[39]={0};
// Logarithmic division scale (roughly - snapped to common units of time)
float timeConstant[39] = {1, 1.58, 2.51, 3.98, 6.31, 10, 15.8, 25.1, 39.8, 60, // 1 minute
                     60*1.58, 60*2.51, 60*3.98, 60*6.31, 60*10, 60*15.8, 60*25.1, 60*39.8, 60*60, // 1 hour
                     60*60*1.58, 60*60*2.51, 60*60*3.98, 60*60*6.31, 60*60*10, 60*60*15.8, 60*60*24, // 1 day
                     60*60*24*1.58, 60*60*24*2.51, 60*60*24*3.98, 60*60*24*6.31, 60*60*24*10, 60*60*24*15.8, 60*60*24*30, // 1 month
                     60*60*24*39.8, 60*60*24*63.1, 60*60*24*100, 60*60*24*158, 60*60*24*251, 60*60*24*365}; // 1 year
bool updateDTE = false;
unsigned short pointerSep;
unsigned char reqMsgCnt = 99;
unsigned char battTemp_x4 = 0;
bool metric = false;

int main() {
    char sTemp[40];
    unsigned long secs;
    unsigned char i,j,display=0,lwt=0;
    point lastTouch;
    float average;

    tt.set_orientation(1);
    tt.background(Black);
    tt.set_display(2);       // select both displays
    tt.cls();
    tt.claim(stdout);        // send stdout to the TFT display
    touchpad.rise(&touch_ISR);
    tt.wfi();               // enable interrupt on touch
    dled = 0.8; // turn on display LED 80%

    timer.start() ;
    RTC_Init(); // start the RTC Interrupts that sync the timer
    struct tm t; // pointer to a static tm structure
    NVIC_SetPriority(CAN_IRQn, 2); //set can priority just below RTC
    NVIC_SetPriority(TIMER3_IRQn, 3); //set ticker priority just below can

    seconds = time(NULL);
    t = *localtime(&seconds) ;
    // is it a date before 2012 ?
    if ((t.tm_year + 1900) < 2012 ) {
        // before 2013 so update year to make date entry easier
        t.tm_year = 2013 - 1900;
        // set the RTC
        set_time(mktime(&t));
        seconds = time(NULL);
    }
    t = *localtime(&seconds) ;
    strftime(sTemp, 32, "%a %m/%d/%Y %X\n", &t);
    printMsg(sTemp); // record RTC
    
    // revision
    sprintf(sTemp,"CANary firmware rev%s\n", revStr); // gg - for Logging the revision
    printMsg(sTemp); // revision

    // Look for new binary on thumbdrive
    // Can't make this work right now since USB doesn't attach the right timestamp (so new binary isn't loaded)
    /*cfile = fopen("/usb/CANary.bin", "rb");
    lastDMode[whichTouched]=99;//force refresh
    if (cfile!=NULL){ //found a new binary on the thumbdrive so copy it over
        sprintf(sTemp,"New binary found.\n");
        printMsg(sTemp); // new binary
        file = fopen("/local/CANary.bin", "wb");
        if (file==NULL){ //failed to open destination
            sprintf(sTemp,"Unable to open destination file.\n");
            printMsg(sTemp); // cannot open CANary.bin
        } else {
            tt.set_display(2);
            tt.foreground(White);
            tt.background(Black);
            tt.cls();
            tt.locate(1,40);
            printf("%s\n","Copying binary - Do no remove power.");
            tt.locate(1,80);
            printf("CANary will reset when complete.\n");
            wait(1); //Wait 1 sec for display DMA to finish before writing file
            while ( int size = fread( writeBuffer, sizeof(char), maxBufLen*13, cfile )){
                fwrite( writeBuffer, sizeof(char), size, file );
                led4=led3;
                led3=led2;
                led2=led1;
                led1=!led4;
            }
        fclose(cfile);
        fclose(file);
        remove("/usb/CANary.bin"); // delete original
        mbed_reset(); //restart
        }
    }*/

    secsNoMsg = 0;

    //read efficiency history data
    cfile = fopen("/local/ehist.cny", "r");
    if (cfile!=NULL){ // found a efficiency history file
        for(i=0;i<39;i++){
            if(!feof(cfile)){
                fscanf(cfile,"%f %f\r\n",&mph[i],&kW[i]);
                mpkWh[i]=mph[i]/kW[i];
            }
        }
        fclose(cfile);
        sprintf(sTemp,"History Loaded.\n");
        printMsg(sTemp); // History loaded
    } else { // create initial file
        sprintf(sTemp,"History not found.  Created.\n");
        printMsg(sTemp); // history not found, created
        for(i=0;i<39;i++){
            // Pre-load with 4 mpkWh @ 40 mph
            mph[i]=40*timeConstant[i];
            kW[i]=10*timeConstant[i];
            mpkWh[i]=4;
        }
    }

    // Read config file
    readConfig();

    // Start monitors
    can1.monitor(true); // set to snoop mode
    can2.monitor(true); // set to snoop mode
    can1.frequency(500000);
    can2.frequency(500000);
    can1SleepMode = 1;         // Turn on Monitor_only Mode
    can2SleepMode = 1;         // Turn on Monitor_only Mode
    can1.attach(&recieve1);
    can2.attach(&recieve2);

    touched=false;
    secsNoTouch=2;
    while (true) {
        if (!logOpen) { // Open new file if one is not already open
            if(logEn){ //logging enable
                seconds = time(NULL);
                t = *localtime(&seconds) ;
                strftime(fileName, 32, "/usb/%m%d%H%M.alc", &t); //mmddhhmm.alc
                //sprintf(sTemp,"Using file %s\n",fileName);
                //printMsg(sTemp); // using alc file ...
                file = fopen(fileName, "ab");
                lastDMode[0]=99;//force refresh
                lastDMode[1]=99;//force refresh
                if(file==NULL){
                    sprintf(sTemp,"\nUnable to open %s\n\n\n\n",fileName);
                    printMsg(sTemp); // cannot open alc file
                    logEn=false;
                    spkr.beep(1000,0.25);
                } else {
                    logOpen = true;
                    readPointer=writePointer;
                    sprintf(sTemp,"Starting Can Log %s\n",fileName);
                    printMsg(sTemp); // starting alc log file 
                    
                    logTS(); // Date Time at start
                    logEvent("Starting"); // Log startup msg for testing
                    sprintf(sTemp,"Cr%s",revStr);
                    logEvent(sTemp); // gg - log firmware version
                    
                    spkr.beep(2000,0.25);
                }
            }//logging enabled
        } else { // if (logOpen)
            pointerSep=(writePointer+maxBufLen-readPointer)%maxBufLen;
            if (pointerSep>(maxBufLen/16)||canIdle||!logEn) {
                // Dump buffer if > 1/16 full or canbus has stopped
                if (file == NULL) {
                    logOpen = false;
                    sprintf(sTemp,"Failed to append log file.\n");
                    printMsg(sTemp); // failed to append 
                    spkr.beep(1000,0.25);
                    logEn=false;
                } else {
                    while (readPointer != writePointer) {
                        for (j = 0; j<13; j++){
                            fprintf(file,"%c",writeBuffer[readPointer][j]);
                        }
                        if(++readPointer >= maxBufLen){
                            readPointer=0;
                            led4 = !led4;
                        }
                    }
                }
            } // if > 1/16 full, canbus has stopped, or logging stopped
            if (!logEn) {
                sprintf(sTemp,"Stopping Can Log %s\n",fileName);
                printMsg(sTemp); // stopping alc log file 
                fclose(file);
                logOpen=false;
                pointerSep=0;
            }
        } // if logOpen
        if (canIdle&&userIdle&&!playbackEn) { // canbus idle --> sleep to save power
            if (repeatPoll) { // stop autopolling if enabled
                autoPoll.detach();
            }
            if (logOpen){
                fclose(file);
            } // if (logOpen)*/
            seconds = time(NULL);
            t = *localtime(&seconds) ;
            strftime(sTemp, 40, "Sleeping: %a %m/%d/%Y %X\n", &t);
            printMsg(sTemp); // sleeping date time
            updateDisplay(0); //Added for turbo3 who has a display override and wants to see the sleep message before going to sleep
            updateDisplay(1);
            //LPC_RTC->CIIR=0x00; // block RTC interrupts
            led1=0;
            led2=0;
            led3=0;
            led4=0;
            dled=0; // turn off display
            secs = time(NULL); // seconds past 12:00:00 AM 1 Jan 1900
            while (secsNoMsg>canTimeout && !touched) {
                //DeepPowerDown();
                tt.wfi(); //enable touch interrupt
                //__wfi(); // freeze CPU and wait for interrupt (from canbus or touch)
                Sleep();
            }
            secsNoTouch=2;
            canIdle=secsNoMsg>canTimeout;
            dled=0.8; // turn on display LED
            seconds = time(NULL);
            t = *localtime(&seconds) ;
            strftime(sTemp, 40, "Waking: %a %m/%d/%Y %X\n", &t);
            printMsg(sTemp); // wakeup date time
            if (time(NULL)>(secs+1800)) {
                logOpen = false; // Start new file if asleep for more than 30 minutes
                if (secsNoTouch>100) secsNoTouch = 100; // also mostly reset user Idle counter
            } else if (logOpen){ // insert timestamp on each wake if logging enabled (disabled for now)
                file = fopen(fileName, "ab");
                logEvent("WakingUp"); // gg - use messeges
                logTS(); // Date-Time at wakeup
            }
            if (repeatPoll) { // re-enable autopolling if enabled
                autoPoll.attach(&autoPollISR,pollInt);
            }
        } // if idle
        
        if(touched){ // call touchscreen procedure if touch interrupt detected
            lastTouch = tt.get_touch();       
            lastTouch = tt.to_pixel(lastTouch);          // convert to pixel pos
            if((lastTouch.x!=639)&&(lastTouch.x!=319)&&(lastTouch.y!=239)){ // filter phantom touches
                if (userIdle) {
                    secsNoTouch=2; // Ignore first touch if user idle
                    userIdle=false;
                } else {
                    secsNoTouch=0;
                }
                if (lastTouch.x>320){
                    whichTouched=1;
                } else {
                    whichTouched=0;
                }
                if (whichTouched!=lwt){
                    lastDMode[lwt]=99; // Repaint lastTouched
                    lwt=whichTouched;
                }
                sMode = 1;
            }
            //sprintf(sTemp,"%d,%d ",lastTouch.x,lastTouch.y);
            //printMsg(sTemp); // touch x,y - for debug
            touched = false; // clear interrupt flag
        }
        //---------------
        // gg - 4x4 touch
        //unsigned char tScrn = 0 ; // screen 0
        unsigned char tCol ;                        
        unsigned char tRow ;
                        
        if (!userIdle) {
            if (secsNoTouch<2) {// Recently touched
                secsNoTouch +=2; // increment to prevent double touch
                sMode = 1;
                //sprintf(sTemp,"button %d %d,%d %d\n",i,buttonX(lastTouch.x,3),buttonY(lastTouch.y,3),lastTouch.x);
                //printMsg(sTemp); // button parms - for debug
                switch (sMode) {
                    case 0: // no select
                        break;
                    case 1: // select screen                        
                        //--------------
                        // gg - 4x4 touch
                        tCol = buttonX(lastTouch.x,4) ;
                        if( tCol >= 4 ){ tCol -= 4; } // touch is on screen 1
                        
                        tRow = buttonY(lastTouch.y,4) ;
                        
                        highlightButton( tCol,tRow, whichTouched, 4,4) ; // gg - highlight
                        
                        if( tRow == tNavRow ) tRow = 7 ; // gg                   
                        switch ( (tCol*10) + tRow ) {
                            //---------------------------------
                            case 00: // top row, left button on screen 0 or 1
                                if (dMode[whichTouched]==monitorScreen||dMode[whichTouched]==changedScreen) {
                                    indexOffset=indexOffset>4?indexOffset-4:1;
                                } else if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = mainScreen ; // GoTo Main Screen
                                    sMode=0;
                                } else if (dMode[whichTouched]==configScreen) {
                                    wait_ms(500);
                                    tt.background(Black);
                                    tt.calibrate();
                                } else if (dMode[whichTouched]==playbackScreen) { // slower
                                        playbackInt *=2;
                                    if(playbackEn){
                                        playback.detach();
                                        playback.attach(&playbackISR,playbackInt);
                                    }
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }
                                break;
                            //-----------------------------------------------
                            case 10: // 1,0 (col left of center,top row) on screen 0 or 1
                                if (dMode[whichTouched]==changedScreen) {
                                    for(j=0;j<100;j++) msgChanged[j]=0; // clear changed data
                                    lastDMode[whichTouched]=99;//force refresh
                                } else if (dMode[whichTouched] == indexScreen) { // gg - index
                                    sMode=0;
                                    dMode[whichTouched] = brakeScreen ; // GoTo Brake Screen
                                } else if (dMode[whichTouched]==cpScreen) {
                                    reqMsgCnt=0;
                                    msgReq.attach(&sendReq,0.015);
                                } else if (dMode[whichTouched]==cpHistScreen) { // gg - hist
                                    reqMsgCnt=0;
                                    msgReq.attach(&sendReq,0.015);
                                } else if (dMode[whichTouched]==cpBarScreen) { // gg - cpbars
                                    reqMsgCnt=0;
                                    msgReq.attach(&sendReq,0.015);
                                } else if (dMode[whichTouched]==configScreen) {
                                    mbed_reset();
                                } else if (dMode[whichTouched]==playbackScreen) { // pause/unpause
                                    playbackEn=!playbackEn;
                                    if(playbackEn){
                                        playback.attach(&playbackISR,playbackInt);
                                    } else {
                                        playback.detach();
                                    }
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }

                                break;
                            //--------------------------------------
                            case 20: // col 2 and row 0 on either screen 0 or 1
                                if (dMode[whichTouched]==monitorScreen||dMode[whichTouched]==changedScreen) {
                                    indexOffset=indexOffset<77?indexOffset+4:80;
                                } else if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = effScreen ; // GoTo EFF Screen
                                    sMode=0;
                                } else if (dMode[whichTouched]==configScreen) {
                                    sprintf(sTemp,"Saving config file.\n");
                                    printMsg(sTemp); // saving config
                                    saveConfig();
                                    spkr.beep(2000,0.25);
                                } else if (dMode[whichTouched]==playbackScreen) { // faster
                                    if(playbackInt>.002){
                                        playbackInt/=2;
                                        if(playbackEn){
                                            playback.detach();
                                            playback.attach(&playbackISR,playbackInt);
                                        }
                                    }
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }

                                break;
                                
                            case 30: // right-most on top row
                                
                                if (dMode[whichTouched]==configScreen) {
                                    // step through skins
                                    if( skin < maxSkin ) skin += 1 ;
                                    else skin = 0 ;
                                    
                                    // repaint both screens, I think
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                    // and re-paint the other screen too, to see new skin there
                                    lastDMode[whichTouched ^ 1]=99; // repaint other screen (^ = XOR)
                                    
                                    //sprintf(sTemp,"Changed Skin to %d.\n");
                                    //printMsg(sTemp); /// changed skin - for debug
                                    //saveConfig();
                                    //spkr.beep(2000,0.25);
                                    
                                } else if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = dteScreen ; // GoTo DTE Screen
                                    sMode=0;
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }

                                break;
                            //----------------------------------
                            //----------------------------------
                            case 01: // left col middle row
                                if (dMode[whichTouched]==configScreen) {
                                    logEn = !logEn;
                                    if (!logEn) {
                                        repeatPoll=false; // disable auto polling, too
                                        autoPoll.detach();
                                    }
                                } else if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = cpScreen ; // GoTo CP Data Screen                                
                                    sMode=0;
                                } else if (dMode[whichTouched]==dateScreen){
                                    dtMode=(dtMode<6)?dtMode+1:0;
                                    lastDMode[whichTouched]=99;
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }

                                break;
                            //------------------------------
                            case 11:
                                if (dMode[whichTouched]==configScreen){
                                    repeatPoll = !repeatPoll;
                                    if (repeatPoll) {
                                        autoPoll.attach(&autoPollISR,pollInt);
                                    } else {
                                        autoPoll.detach();
                                    }
                                } else if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = cpHistScreen ; // GoTo CP Hist Screen
                                    sMode=0;
                                } else if (dMode[whichTouched]==playbackScreen) {
                                    // Start/stop playback
                                    if(!playbackOpen){
                                        if(!logOpen){
                                            file = fopen("/usb/playback.alc", "rb");                                          
                                            lastDMode[whichTouched]=99;//force refresh
                                            if(file==NULL){
                                                sprintf(sTemp,"Unable to open /usb/playback.alc\n");
                                                printMsg(sTemp); // no playback.alc
                                                spkr.beep(1000,0.25);
                                            } else {
                                                playbackOpen = true;
                                                playbackEn=true;
                                                playback.attach(&playbackISR,playbackInt);
                                                sprintf(sTemp,"Starting playback\n");
                                                printMsg(sTemp); // start playback
                                                spkr.beep(2000,0.25);
                                                can1.attach(&doNothing);// Stop recieving CAN data
                                                can2.attach(&doNothing);
                                            }
                                        } else {
                                            sprintf(sTemp,"Must stop logging first\n");
                                            printMsg(sTemp); // Must stop logging first
                                        }
                                    } else {
                                        playback.detach();
                                        fclose(file);
                                        playbackOpen=false;
                                        playbackEn=false;
                                        can1.attach(&recieve1);// Restore CAN data recieve
                                        can2.attach(&recieve2);
                                        lastDMode[whichTouched]=99;
                                    }
                                } else if (dMode[whichTouched]==dateScreen){
                                    upDate(dtMode,true);
                                    lastDMode[whichTouched]=99;
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }

                                break;
                            //---------------------------------
                            case 21: // col 2 row 1
                                if (dMode[whichTouched]==configScreen) { // gg - Batt Log Enable Button
                                    yesBattLog = !yesBattLog;
                                } else if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = cpBarScreen ; // GoTo CP Bars Screen  
                                    sMode=0;
                                } else if (dMode[whichTouched]==dateScreen){
                                    upDate(dtMode,false);
                                    lastDMode[whichTouched]=99;
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }

                                break;
                                
                            case 31: // col 3 row 1
                                if (dMode[whichTouched]==configScreen) { // gg - Batt Log Enable Button
                                    debugMode = !debugMode;                                
                                } else if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = configScreen ; // GoTo Config Screen                                   
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }                            
                                break;
                                
                            //-----------------------------------
                            case 02: // left col, bottom row (not nav)
                                if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = playbackScreen ; // GoTo Playback Screen                                    
                                } else if (dMode[whichTouched]==configScreen) {
                                    metric = !metric; // toggle metric/imperial display
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }            
                                break;
                                
                             case 12: // left-middle col, bottom row (not nav)
                                if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = dateScreen ; // GoTo Set Date/Time Screen  
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                } 
                                break;
                             
                             case 22: // right-middle col, bottom row (not nav)
                                if (dMode[whichTouched] == indexScreen) { // gg - index
                                    dMode[whichTouched] = logScreen ;    
                                } else {
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                } 
                                break;

                             case 32: // right col, bottom row (not nav)  
                                if (dMode[whichTouched] == configScreen) {
                                    updateFirmware();
                                } else {                             
                                    lastDMode[whichTouched]=99;//repaint to clear highlight
                                }
                                break;

                            //-----------------------------------
                            //-----------------------------------
                            // Prev Navigation
                            case 07: // col 0 row tNavRow
                                dMode[whichTouched]=dMode[whichTouched]>0?dMode[whichTouched]-1:maxScreens;
                                break;
                            //-----------------------------------
                            // Select Screen Navigation
                            case 17:
                                //secsNoTouch = userTimeout; // immediately exit config mode
                                sMode=0;
                                lastDMode[whichTouched]=99; // Repaint
                                break;
                            //-----------------------------------
                            // Index Navigation
                            case 27: // col 2 row tNavRow
                                dMode[whichTouched]= indexScreen ; // gg - index
                                break;
                            //------------------------------------
                            // Next Navigation
                            case 37: // lower right on Nav Line gg - move next                            
                                dMode[whichTouched]=dMode[whichTouched]<maxScreens?dMode[whichTouched]+1:0;
                                break;
                            //------------------------------------
                            //------------------------------------
                            default:
                                lastDMode[whichTouched]=99;//repaint to clear highlight
                                break;
                        }
                        break;
                    case 2: // numpad
                        break;
                    case 3:
                        break;
                    default:
                        break;
                } // case sMode
            } //recently touched
        } else { // userIdle
            if(sMode==1){
                sMode=0;
                lastDMode[whichTouched]=99;
            }
        }

        if(tick){ // Executes once a second
            headlights = (lastMsg[indexLastMsg[0x358]].data[1]&0x80)?true:false;  // headlight/turn signal indicator
            accV=floor(mon12V*scale12V*10+0.5)/10; //Round to nearest 10th
            accOn=(accV>5)?true:false;
            if(laccOn&&!accOn){ // Car turned off
                //write efficiency history data
                cfile = fopen("/local/ehist.cny", "w");
                if (cfile!=NULL){ // found a efficiency history file
                    for(i=0;i<39;i++){
                        fprintf(cfile,"%f %f\r\n",mph[i],kW[i]);
                    }
                    fclose(cfile);
                }
            }
            laccOn=accOn;
            if(!accOn&&!logEn&&userIdle&&!playbackEn){
                //sprintf(sTemp,"Display Off %4.2f\n",accV);
                //printMsg(sTemp); // display off - for debug
                
                dled = 0; // turn off display if car off and logging disabled and no user activity
            }else if(!headlights){
                dled = ledHi;
            } else {
                dled = ledLo;
            }
            
            //compute historic efficiency
            if(numSsamples>0){ // Avoid div0
                mph[0]=((float) motorRPM)/numSsamples/215; // Empirically derived - may change car to car
            } else {
                mph[0]=0;
            }
            if(mph[0]>99){
                mph[0]=0;
            }
            mpkWh[0]=mph[0];
            if(numWsamples>0){ // Avoid div0
                kW[0]=((float) mWs_x4)/numWsamples/4e3;     
                mpkWh[0]/=kW[0];
                if (mpkWh[0]<0) {
                    mpkWh[0]=99;// negative means inf.
                }
            } else {
                kW[0]=0;
                mpkWh[0]=0;
            }
            //mpkWh[0]=floor(mpkWh[0]*10+0.5)/10; // Round to nearest 10th
            motorRPM=0;
            numSsamples=0;
            mWs_x4=0;
            numWsamples=0;
            if(accOn||playbackEn){
                for(i=1;i<39;i++){
                    average=mph[i]/timeConstant[i];
                    mph[i]-=average;
                    mph[i]+=mph[0];
                    mpkWh[i]=average;
                    average=kW[i]/timeConstant[i];
                    kW[i]-=average;
                    kW[i]+=kW[0];
                    mpkWh[i]/=average;
                    if (mpkWh[i]<0) {
                        mpkWh[i]=99;// negative means inf.
                    }
                    //mpkWh[i]=floor(mpkWh[i]*10+0.5)/10; // Round to nearest 10th
               }
            }
            updateDTE=true;
            if(logCP)
                logPackVoltages(); // Turbo3, only call
            tick=false;
        }

        display=display<1?display+1:0; // toggle display
        updateDisplay(display);

        /*if(pollCP){ // We do this inside main loop instead of ticker so CAN RX will not be blocked
            sendCPreq(); // send cellpair data request.
            wait_ms(16);
            sendTreq(); //send temperature request
            pollCP=false;
        }*/
        
        if(step){ // playback
            if(playbackOpen&&playbackEn){
                for(i=0;i<120;i++){
                    if(!feof(file)){
                        fscanf(file,"%5c%8c",&header,&data);
                        logCan(header[0],CANMessage(0x7ff&((header[4]<<8)+header[3]), data, 8)); // Playback
                    } else {
                        fclose(file); // restart
                        file = fopen("/usb/playback.alc", "rb");                                          
                        lastDMode[whichTouched]=99;//force refresh
                        spkr.beep(2000,0.25);
                    }
                }
            }
            step=false;
        }

    } //while (true)
}