// utility.cpp
#include "utility.h"

void mbed_reset();

void RTC_IRQHandler() {
    timer.reset(); // zero ms at the-seconds-tic
    canIdle=(++secsNoMsg>canTimeout)?true:false;
    userIdle=(++secsNoTouch>userTimeout)?true:false;
    LPC_RTC->ILR |= (1<<0); // clear interrupt to prepare for next
    tick=true;
    // will use this to generate a logTP() just before the next Message received.
    if( (time(NULL) % 60) == 0) ZeroSecTick = true; // gg - at 0-second of each minute
}

void RTC_Init (void) {
    LPC_RTC->ILR=0x00; // set up the RTC interrupts
    LPC_RTC->CIIR=0x01; // interrupts each second
    LPC_RTC->CCR = 0x01;  // Clock enable
    //NVIC_SetPriority( RTC_IRQn, 10 );
    NVIC_EnableIRQ( RTC_IRQn );
}

void printMsg (char *msg) {
    strcpy(displayLog[displayLoc],msg);
    displayLoc=displayLoc>17?0:displayLoc+1;
}

void touch_ISR(){
    //LPC_GPIOINT->IO2IntClr = (LPC_GPIOINT->IO2IntStatR | LPC_GPIOINT->IO2IntStatF); // seems to work without so maybe not necessary (performed inInterruptIn handler?)
    touched=true; // just set flag - touch screen algorythm is long and we don't want to block other interrupts
}

unsigned short getTimeStamp() {
    unsigned short msec = timer.read_ms() ; // read ms from the timer
    unsigned long secs = time(NULL); // seconds past 12:00:00 AM 1 Jan 1900
    unsigned short isecs = secs%60 ; // modulo 60 for 0-59 seconds from RTC
    return ((isecs<<10)+msec) ; // return the two byte time stamp
}

void logCan (char mType, CANMessage canRXmsg) {

   // re-arranged to put static first
    static unsigned char ii = 0;
    static unsigned char lasti = 0; // indexindex
    static unsigned char bdi=0;
    static signed short imotorRPM = 0;
    static unsigned short nLost = 0; // gg - overrun
 
    char sTemp[40];    
    unsigned char changed;
    unsigned short i; // was unsigned char
    signed short packV;
    signed short packA;
    signed long imWs_x4;
    unsigned short ts;

    secsNoMsg=0; // reset deadman switch
    if(debugMode||(skin==ggSkin)){ 
        // code to insert actual number of dropped frames for overrun debug - skiped in normal mode to keep logcan short
        if(logOpen){
            if(canRXmsg.id>0) {
                // check to see if buffer is already full (read - write) = 1
                // actually the last buffer location cannot be used because then 
                //   the buffer would look empty after writePointer++
                
                //if (((writePointer+maxBufLen-readPointer)%maxBufLen)>(maxBufLen/16)) // modulo is slow?
     
                // pointers are 0 through maxBufLen-1
                if( (readPointer - writePointer) == 1 || (writePointer - readPointer) == (maxBufLen - 1)) {
                    // the buffer is "full", so Lose this message
                    
                    // point to the last-stored message
                    int tempWritePointer = writePointer - 1 ;
                    if( tempWritePointer < 0 ) tempWritePointer = maxBufLen - 1;
                    char strLost[9] ;
     
                    if( nLost == 0 ) {
                        // this is the first message lost 
                        //   and we must overwrite the last message with an FFE comment message
                        // So, there will be two messages lost as the comment message is laid in.
                        nLost = 2;
                        sprintf(strLost,"%s","Lost0002"); // indicate two messages lost
                        
                        // overlay the last message with a "Lost0002" comment
                        writeBuffer[tempWritePointer][0]=0;
                        // leave the ts of the overlaid message
                        //writeBuffer[tempWritePointer][1]=(ts&0xff00)>>8; // Time Stamp (2 bytes_
                        //writeBuffer[tempWritePointer][2]=(ts&0x00ff);
                        // force the MsgID to an Event Message 
                        writeBuffer[tempWritePointer][3]=0xfe; // MsgID, low byte
                        writeBuffer[tempWritePointer][4]=0xff; // Len nibble, and MsgID high nibble
                        // lay in the "Lost0002" text
                        for(i=5;i<13;i++){ 
                            writeBuffer[tempWritePointer][i]= strLost[i-5];
                        }
                    } else {
                        // at least one message was previously lost
                        // increment the loat counter
                        nLost += 1;
                        
                        // lay the new count into the comment
                        sprintf(strLost,"%04d",nLost);
                        for(i=9;i<13;i++){ 
                            writeBuffer[tempWritePointer][i]= strLost[i-9];
                        }
                    }
                } else {
                    // there is room to insert the message
                    // get it inserted quickly
                    ts=getTimeStamp(); 
                    writeBuffer[writePointer][0]=mType;
                    writeBuffer[writePointer][1]=(ts&0xff00)>>8; // Time Stamp (2 bytes_
                    writeBuffer[writePointer][2]=(ts&0x00ff);
                    writeBuffer[writePointer][3]=canRXmsg.id&0xff; // MsgID, low byte
                    char sLen = canRXmsg.len ;
                    writeBuffer[writePointer][4]=(canRXmsg.id>>8)+(sLen<<4); // Len nibble, and MsgID high nibble
                    for(i=0;i<8;i++){ // Is there a better way to do this? (writeBuffer[writePointer][i]=canRXmsg.data?)
                        if(i<sLen) 
                            writeBuffer[writePointer][i+5]=canRXmsg.data[i];
                        else // i>=sLen
                            // force unused data bytes to FF for CAN-Do compatibility
                            writeBuffer[writePointer][i+5]=0xFF;
                    }
                    
                    //--------------
                    // Note, this is not protected from the interrupt.
                    // Due to the nLost code above, this no longer
                    //    overflows to writePointer = readPointer
                    //    which would make the buffer look empty
                    if (++writePointer >= maxBufLen) {
                        writePointer = 0;
                        led3 = !led3;
                    }
                    //--------------
                    // log a local message if we had lost messages. gg - logcan
                    if( nLost > 0 ) {
                        // We previously lost messages that did not get into the buffer
                        sprintf(sTemp,"-- Lost %d Messages.\n", nLost);
                        printMsg(sTemp); // write buffer overrun
                        //spkr.beep(500,0.25);
                        
                        nLost = 0 ;
                    }
                    //--------------
                }
            }
        }
    }else{ // not debugMode - keep code short
        if(logOpen){
            NVIC_DisableIRQ(CAN_IRQn);  // Block interrupts until write pointer assigned
            int localWritePointer = writePointer++; // create local copy to make logCan reentrant
            // note that the static variables do not prevent safe reentry
            // since they are only used for msgId<0x800 which will never interrupt
            // another msgId<0x800 (both CANbusses are same priority)
            if (writePointer >= maxBufLen) {
                writePointer = 0;
                led3 = !led3;
            }
            NVIC_EnableIRQ(CAN_IRQn);  // Unblock interrupts once local pointer set and global pointer incremented
            ts=getTimeStamp();
            writeBuffer[localWritePointer][0]=mType;
            writeBuffer[localWritePointer][1]=(ts&0xff00)>>8;
            writeBuffer[localWritePointer][2]=(ts&0x00ff);
            writeBuffer[localWritePointer][3]=canRXmsg.id&0xff;
            writeBuffer[localWritePointer][4]=(canRXmsg.id>>8)+(canRXmsg.len<<4);
            for(i=5;i<13;i++){ // Is there a better way to do this? (writeBuffer[localWritePointer][5]=canRXmsg.data?)
                writeBuffer[localWritePointer][i]=canRXmsg.data[i-5];
            }
            if (writePointer==readPointer) {
                // Just caught up to read pointer
                sprintf(sTemp,"Write buffer overrun.\n");
                printMsg(sTemp); // write buffer overrun
                spkr.beep(500,0.25);
            }
        }
    }

    if(canRXmsg.id<0x800){ // Block FFE and FFF messages
        if(indexLastMsg[canRXmsg.id]==0) { //Check if no entry
            //ii=ii<99?ii+1:0; // Should never wrap - less than 100 different messages ever used
            if(ii<99) {
                //indexLastMsg[canRXmsg.id]=ii; //Create entry if first message
                indexLastMsg[canRXmsg.id]=++ii; //Create entry for first MsgID occurance
                // ii max is 99 here
            } else {
                // the ii array is full, more than 100 MsgIDs found
                if(ii==99) {
                    ii++; // step to 100 to log only one error
                    sprintf(sTemp,"MsgID buffer overrun.\n");
                    printMsg(sTemp); // write buffer overrun
                }
            }
        }
        
        //----------------
        if(dMode[0]==changedScreen||dMode[1]==changedScreen){// Skip if not using (for execution speed)
            changed=msgChanged[indexLastMsg[canRXmsg.id]];
            // This is cleared in the main loop when reset button is touched
            for(i=0;i<8;i++){
                if(lastMsg[indexLastMsg[canRXmsg.id]].data[i]!=canRXmsg.data[i]){
                    changed |= 1<<i;
                }
            }
            msgChanged[indexLastMsg[canRXmsg.id]]=changed;
        }
    
        lastMsg[indexLastMsg[canRXmsg.id]]=canRXmsg; //Store in table
        
        //-------------------
        //Miscellaneous on-recieve operations below
        if((mType==1)&&(canRXmsg.id==0x7bb)){ // is battery data?  Need to store all responses
            if(canRXmsg.data[0]<0x20){
                if(canRXmsg.data[3]==2){//Group 2 = cellpair data
                    bdi=BatDataBaseG2; // index offset for CP data (uses 00 - 1C)
                    sprintf(sTemp,"  Getting cell pair data\n");
                    printMsg(sTemp);
                    
                }else if(canRXmsg.data[3]==4){//Group 4 = temperature data
                    bdi=BatDataBaseG4; // index offset for Temperature data (uses 20 - 22)
                    sprintf(sTemp,"  Getting temperature data\n");
                    printMsg(sTemp);
                    
                }else if(canRXmsg.data[3]==1){//Group 1 data
                    bdi=BatDataBaseG1; // index offset for Group 1 data (uses 20 - 22)
                    sprintf(sTemp,"  Getting Group 1 data\n");
                    printMsg(sTemp);
                    
                }else if(canRXmsg.data[3]==3){//Group 3 data
                    bdi=BatDataBaseG3; // index offset for Group 3 data (uses 20 - 22)
                    sprintf(sTemp,"  Getting Group 3 data\n");
                    printMsg(sTemp);
                    
                }else if(canRXmsg.data[3]==5){//Group 5 data
                    bdi=BatDataBaseG5; // index offset for Group 5 data (uses 20 - 22)
                    sprintf(sTemp,"  Getting Group 5 data\n");
                    printMsg(sTemp);
                    
                }else bdi=0xff; // ignore other messages (for now)
                lasti=0;
            }
            
            if(bdi<0xff){
                i=canRXmsg.data[0]&0x0f; //lower nibble of D0 is index
                if(lasti>i){ //detect rollover and offset index appropriately
                    bdi=BatDataBaseG2 + 0x10; // only for CP data
                }
                lasti=i; //remember the msb to detect rollover next time around
                i+=bdi;
                //-------
                if(i==BatDataBaseG4+2){ // Last of Temperature data
                    logCP=yesBattLog; // Only log if logging enabled
                    showCP=true; // Always show
                    battTemp_x4=battData[224+5]+battData[224+8]+battData[224+11]+battData[224+14];
                }
                //-------
                i*=7;
                //if(i<0xfa){ // Is there a better way to do this?
                if(i+6 < BatDataBufMax) {
                    battData[i+0]=canRXmsg.data[1];
                    battData[i+1]=canRXmsg.data[2];
                    battData[i+2]=canRXmsg.data[3];
                    battData[i+3]=canRXmsg.data[4];
                    battData[i+4]=canRXmsg.data[5];
                    battData[i+5]=canRXmsg.data[6];
                    battData[i+6]=canRXmsg.data[7];
                }
            }
        }else if((mType==1)&&(canRXmsg.id==0x1db)){ //Battery Volts and Amps
            packV=((canRXmsg.data[2]<<2)|(canRXmsg.data[3]>>6)); // 1 LSB = 0.5V
            packA=((canRXmsg.data[0]<<3)|(canRXmsg.data[1]>>5)); // 1 LSB = 0.5A
            if(packA>0x03ff){
                packA|=0xf800;//extend sign;
            }
            packA -= 1; //Slight correction to value required (unique to my Leaf?)
            imWs_x4 = packV; // Volts*milliSeconds*2
            imWs_x4 *= -packA; // milliWattseconds*4
            if (!((imotorRPM<2)&&(imWs_x4<0))){ //Ignore if charging from wall
                mWs_x4 += imWs_x4; // total mWs_x4
                numWsamples++;
            }
        }else if((mType==1)&&(canRXmsg.id==0x1da)){ //Motor Speed
            imotorRPM=((canRXmsg.data[4]<<8)|(canRXmsg.data[5]));
            if(imotorRPM<0){ // take absolute value
                imotorRPM=-imotorRPM;
            }
            motorRPM+=imotorRPM;
            numSsamples++;
        }
    }
}

//-----------------------------
void logTS () {
    CANMessage tsMsg;
    unsigned long secs = time(NULL); // seconds past 12:00:00 AM 1 Jan 1900
    // NOTE: In Mbed, I believe that this is seconds past start of 1970, not 1900
    //   but this is good, since seconds past 1970 is what CAN-Do expects. GG - Date Time
    tsMsg.id=0xfff;
    tsMsg.len=0xf;
    tsMsg.data[0]=secs&0xff; 
    tsMsg.data[1]=(secs>>8)&0xff;
    tsMsg.data[2]=(secs>>16)&0xff;
    tsMsg.data[3]=(secs>>24)&0xff;
    tsMsg.data[4]=0; // 0xff; gg - Date Time
    tsMsg.data[5]=0; // 0xff; for CAN-Do
    tsMsg.data[6]=0; // 0xff;
    tsMsg.data[7]=0xff;
    logCan(0,tsMsg); // Date-Time
}

void logEvent (char * errMsg) {
    // log CAN-Do 8-character Pseudo Message
    CANMessage tsMsg;
    tsMsg.id=0xffe; // pseudo Message to CAN-Do log
    tsMsg.len=0xf;
    int iMsgLen = strlen(errMsg);
    // 8 character message compatible with CAN-Do
    for(int i=0; i<8; i++){
      tsMsg.data[i]=' '; 
      if( i < iMsgLen ) tsMsg.data[i]=errMsg[i];
    }
    logCan(0,tsMsg); // FFE Comment Message
}

void sendReq() {
    static char data[8] = {0x02, 0x21, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff};
    if(reqMsgCnt<99){
        switch (reqMsgCnt){
            case 0:
                can1.monitor(false); // set to active mode
                can1SleepMode = 0; // enable TX
                data[0]=0x02; //change to request group 1
                data[1]=0x21;
                data[2]=0x01;
                break;
            case 6: // group 1 has 6 frames
                can1.monitor(false); // set to active mode
                can1SleepMode = 0; // enable TX
                data[0]=0x02; //change to request group 2 (cp data)
                data[1]=0x21;
                data[2]=0x02;
                break;
            case 35: // group 2 has 29 frames
                data[0]=0x02; //change to request group 3
                data[1]=0x21;
                data[2]=0x03;
                break;
            case 40: // group 3 has 5 frames
                data[0]=0x02; //change to request group 4 (temperature)
                data[1]=0x21;
                data[2]=0x04;
                break;
            case 43: // group 4 has 3 frames
                data[0]=0x02; //change to request group 5
                data[1]=0x21;
                data[2]=0x05;
                break;
            case 54: // group 5 has 11 frames
                reqMsgCnt = 99;
                can1SleepMode = 1; // disable TX
                can1.monitor(true); // set to snoop mode
                msgReq.detach(); // stop ticker
            default:
                data[0]=0x30; //change to request next line message
                data[1]=0x01;
                data[2]=0x00;
        }
        can1.write(CANMessage(0x79b, data, 8));
        reqMsgCnt++;
    }
}

void autoPollISR(){
    char sTemp[40]; // just for debug
    sprintf(sTemp,"Requesting cp data\n"); // just for debug
    printMsg(sTemp); // just for debug
    reqMsgCnt = 0; //reset message counter
    msgReq.attach(&sendReq,0.015);
}

void playbackISR() { //Used for autoplayback
    step=true;
}

void doNothing(){ //CAN deattach work-around
}

void recieve1() {
    CANMessage msg1;
    can1.read(msg1);
    
    if( ZeroSecTick ) { ZeroSecTick = false; logTS(); } // gg - 0-second EV bus
    
    logCan(1, msg1); // EVcan Message Received
    led1 = !led1;
}

void recieve2() {
    CANMessage msg2;
    can2.read(msg2);
    
    if( ZeroSecTick ) { ZeroSecTick = false; logTS(); } // gg - 0-second EV bus
    
    logCan(2, msg2); // CARcan Message Received
    led2 = !led2;
}

unsigned char buttonX(unsigned short X, unsigned char columns) {
    unsigned char val = X*columns/320;
    return val;
}

unsigned char buttonY(unsigned short Y, unsigned char rows) {
    unsigned short val = Y*rows/240;
    return val;
}

void saveConfig(){
    FILE *cfile;
    cfile = fopen("/local/config.txt", "w");
    
    fprintf(cfile,"format 5\r\n");
    fprintf(cfile,"x0_off %d\r\n",tt.x0_off);
    fprintf(cfile,"y0_off %d\r\n",tt.y0_off);
    fprintf(cfile,"x0_pp %d\r\n",tt.x0_pp);
    fprintf(cfile,"y0_pp %d\r\n",tt.y0_pp);
    fprintf(cfile,"x1_off %d\r\n",tt.x1_off);
    fprintf(cfile,"y1_off %d\r\n",tt.y1_off);
    fprintf(cfile,"x1_pp %d\r\n",tt.x1_pp);
    fprintf(cfile,"y1_pp %d\r\n",tt.y1_pp);
    fprintf(cfile,"x_mid %d\r\n",tt.x_mid);
    if (dMode[0]==configScreen)
        fprintf(cfile,"dMode0 %d\r\n",mainScreen);
    else
        fprintf(cfile,"dMode0 %d\r\n",dMode[0]);
    if (dMode[1]==configScreen)
        fprintf(cfile,"dMode1 %d\r\n",mainScreen);
    else
        fprintf(cfile,"dMode1 %d\r\n",dMode[1]);
    fprintf(cfile,"ledHi %4.3f\r\n",ledHi);
    fprintf(cfile,"ledLo %4.3f\r\n",ledLo);
    fprintf(cfile,"pollInt %d\r\n",pollInt);
    fprintf(cfile,"scale12V %4.2f\r\n",scale12V);
    fprintf(cfile,"skin %d\r\n",skin);
    fprintf(cfile,"dtePeriod %d\r\n",dtePeriod);
    fprintf(cfile,"DebugMode %d\r\n",(debugMode?1:0));
    fprintf(cfile,"metric %d\r\n",(metric?1:0));
    fprintf(cfile, "firmware %d\r\n", fwCount );            
    fclose(cfile);
}

 void readConfig(){
    FILE *cfile;
    int ff;
    char sTemp[40];
    cfile = fopen("/local/config.txt", "r");
    if (cfile==NULL){ // if doesn't exist --> create
        sprintf(sTemp,"No config file found.\n");
        printMsg(sTemp); // no config file
        sprintf(sTemp,"Calibrating touch screen.\n");
        printMsg(sTemp); // calibrating
        //tt.setcal(5570, 34030, 80, 108, 33700, 5780, 82, 108, 32500);// bypass calibration using my values
        tt.calibrate();   // run touchscreen calibration routine
        // NOTE: calibrates screen 1 first, then screen 0.
        saveConfig();
    } else {
        ledHi = 0.823;
        ledLo = 0.1;
        pollInt = 300;
        scale12V = 16.2;
        skin = ttSkin;
        fscanf(cfile, "format %d\r\n", &ff );
        fscanf(cfile, "x0_off %d\r\n", &tt.x0_off );
        fscanf(cfile, "y0_off %d\r\n", &tt.y0_off );
        fscanf(cfile, "x0_pp %d\r\n", &tt.x0_pp );
        fscanf(cfile, "y0_pp %d\r\n", &tt.y0_pp );
        fscanf(cfile, "x1_off %d\r\n", &tt.x1_off );
        fscanf(cfile, "y1_off %d\r\n", &tt.y1_off );
        fscanf(cfile, "x1_pp %d\r\n", &tt.x1_pp );
        fscanf(cfile, "y1_pp %d\r\n", &tt.y1_pp );
        fscanf(cfile, "x_mid %d\r\n", &tt.x_mid );
        fscanf(cfile, "dMode0 %d\r\n", &dMode[0] );
        fscanf(cfile, "dMode1 %d\r\n", &dMode[1] );
        if(ff>1){
            fscanf(cfile, "ledHi %f\r\n", &ledHi );
            fscanf(cfile, "ledLo %f\r\n", &ledLo );
            fscanf(cfile, "pollInt %d\r\n", &pollInt );
            fscanf(cfile, "scale12V %f\r\n", &scale12V );
        }
        if(ff>2){
            fscanf(cfile, "skin %d\r\n", &skin );
            fscanf(cfile, "dtePeriod %d\r\n", &dtePeriod );
        }
        if(ff>3){
            int iDebug;
            fscanf(cfile, "DebugMode %d\r\n", &iDebug );            
            debugMode = (bool)iDebug;
        }
        if(ff>4) {
            int iMetric;
            fscanf(cfile, "metric %d\r\n", &iMetric );            
            metric = (bool)iMetric; 
            fscanf(cfile, "firmware %d\r\n", &iMetric );
            fwCount = iMetric;
        }
        fclose(cfile);
        
        //if(ff<3){//If not latest format, save as latest format
        if(ff<4){//If not latest format, save as latest format
            saveConfig();
            sprintf(sTemp,"Config file format updated.\n");
            printMsg(sTemp); // config forat updates
        }
        sprintf(sTemp,"Config file loaded.\n");
        printMsg(sTemp); // config file loaded
    }
}

void upDate(unsigned char field, bool upDownBar){
    struct tm t; // pointer to a static tm structure
    time_t seconds ;
    seconds = time(NULL);
    t = *localtime(&seconds) ;
    switch(field){
        case 0: // year
            if (upDownBar) {
                t.tm_year = t.tm_year+1;
            } else {
                t.tm_year = t.tm_year-1;
            }
            break;
        case 1: // month
            if (upDownBar) {
                t.tm_mon = (t.tm_mon<12)?t.tm_mon+1:1;
            } else {
                t.tm_mon = (t.tm_mon>2)?t.tm_mon-1:12;
            }
            break;
        case 2: // day
            if (upDownBar) {
                t.tm_mday = (t.tm_mday<31)?t.tm_mday+1:1;
            } else {
                t.tm_mday = (t.tm_mday>2)?t.tm_mday-1:31;
            }
            break;
        case 3: // hour
            if (upDownBar) {
                t.tm_hour = (t.tm_hour<23)?t.tm_hour+1:0;
            } else {
                t.tm_hour = (t.tm_hour>1)?t.tm_hour-1:23;
            }
            break;
        case 4: // minute
            if (upDownBar) {
                t.tm_min = (t.tm_min<59)?t.tm_min+1:0;
            } else {
                t.tm_min = (t.tm_min>1)?t.tm_min-1:59;
            }
            break;
        case 5: // second
            if (upDownBar) {
                t.tm_sec = (t.tm_sec<59)?t.tm_sec+1:0;
            } else {
                t.tm_sec = (t.tm_sec>1)?t.tm_sec-1:59;
            }
            break;
        default:
            break;
    }
    set_time(mktime(&t));
}

void logPackVoltages() { // Turbo3 - routine to dump CP values to text file
    char sTemp[40];
    struct tm t; // pointer to a static tm structure
    short unsigned max, min, jv, i, bd;
    unsigned avg;
    unsigned short gids, SOC, packV;
    signed short packA;
    time_t seconds ;
    
    CANMessage msg;
    
    seconds = time(NULL); // Turbo3
    t = *localtime(&seconds) ; // Turbo3 
    
    msg = lastMsg[indexLastMsg[0x5bc]]; //Get gids
    gids = (msg.data[0]<<2)+(msg.data[1]>>6);
    msg = lastMsg[indexLastMsg[0x55b]]; //Get SOC
    SOC = (msg.data[0]<<2)+(msg.data[1]>>6);
    msg = lastMsg[indexLastMsg[0x1db]]; //Get pack volts
    packV = (msg.data[2]<<2)+(msg.data[3]>>6);
    packA = (msg.data[0]<<3)+(msg.data[1]>>5);
    if (packA & 0x400) packA |= 0xf800;
    
    max=0;
    min=9999;
    avg=0;
    for(i=0; i<96; i++) {
        bd=(battData[i*2+3]<<8)+battData[i*2+4];
        avg+=bd;
        if(bd>max) max=bd;
        if(bd<min) min=bd;
    }
    avg /= 96;
    if(min<3713) {
        jv=avg-(max-avg)*1.5;
    } else { // Only compute judgement value if min cellpair meets <= 3712mV requirement
        jv=0;
    }
    
    FILE *bfile;
    //bfile = fopen("/local/batvolt.txt", "a");
    bfile = fopen("/usb/batvolt.txt", "a");
    if(bfile!=NULL) {
        strftime(sTemp, 40, "%a %m/%d/%Y %X", &t);
        fprintf(bfile,"%s,%d,%5.1f%%,%5.1f,%5.1f,%d,%d,%d,%d,%d",sTemp,gids,(float)SOC/10,(float)packV/2,(float)packA/2,max,min,avg,max-min,jv);
        // BatDataBaseG4 * 7 = 224        
        fprintf(bfile,"%d,%d,%d,%d,",(battData[224+ 3]<<8)+battData[224+ 4],battData[224+ 5],(battData[224+ 6]<<8)+battData[224+ 7],battData[224+ 8]);
        fprintf(bfile,"%d,%d,%d,%d", (battData[224+ 9]<<8)+battData[224+10],battData[224+11],(battData[224+12]<<8)+battData[224+13],battData[224+14]);
        for(i=0; i<96; i++) {
            bd=(battData[i*2+3]<<8)+battData[i*2+4];
            fprintf(bfile,",%d",bd);
        }
        fprintf(bfile,"\r\n");
        fclose(bfile);
    }
    logCP=false;
    showCP=true;
}


//LM - updates firmware off a usb key, eliminating the need to plug
//the CANary into a computer for updates.
void updateFirmware()
{
    fwCount ++;
    saveConfig();    
    tt.cls();
    printf("Saved Configuration\n");
    //delete all bin files in /local
    DIR *dir;
    char sTemp[40];
    struct dirent *ent;
    printf("Starting update\n");
    printf("deleting old firmware files\n");
    if ((dir = opendir ("/local/")) != NULL) {
      /* print all the files and directories within directory */      
      while ((ent = readdir (dir)) != NULL) {
            //printf("FILE: %s\n",ent->d_name);
            char dest[4] = "";
            strncat(dest, &ent->d_name[strlen(ent->d_name)-3],3);            
            dest[0] = tolower(dest[0]);
            dest[1] = tolower(dest[1]);
            dest[2] = tolower(dest[2]);                        
            if(strcmp(dest,"bin")==0)
            {                            
                sprintf(sTemp,"/local/%s",ent->d_name);
                int result = remove(sTemp);       
                printf("REMOVED: %s",ent->d_name);
            }
      }
      closedir (dir);
    } else {
      /* could not open directory */
        printf("Couldnt open folder");
        wait(5);
        return;
    }        
    printf("copying new firmware\n");
    tt.cls();
    //Copy the new firmware from usb->local
    //The newest bin file is the one that is used by the mbed
    const int bufSize = 2048;
    FILE *destFile;    
    sprintf(sTemp,"/local/fw%d.bin",fwCount);
    printf("Writing %s\n",sTemp);
    wait(2);
    destFile = fopen(sTemp, "wb");
    FILE *srcFile;    
    srcFile = fopen("/usb/firmware.bin", "rb");    
    if(srcFile ==NULL)
    {        
        sprintf(sTemp,"Couldn't find firmware.bin\n");
        printf(sTemp);
        wait(5);
        return;
    }
    if(destFile == NULL)
    {
        sprintf(sTemp,"Couldn't Open Destination\n");
        printf(sTemp);
        wait(5);
        return;
    }
    char buffer[bufSize];

    while (!feof(srcFile))
    {
        int n = fread(buffer, 1, bufSize, srcFile);
        fwrite(buffer, 1, n, destFile);
    }

    fflush(destFile);
    fclose(destFile);
    fclose(srcFile);
    tt.cls();
    printf("Succesful\n\n");
    printf("Rebooting in 5 seconds\n");
    wait(5);
    //Now run new firmware
    mbed_reset();
}