// This contains all the display subroutines

#include "TOUCH_TFTx2.h"
#include "Arial12x12.h"
#include "Arial12x12_prop.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "Neu42x35.h"
#include "SCProSB31x55.h"
#include "common.h"

extern CANMessage lastMsg[100];
extern unsigned char indexOffset;
extern unsigned char msgChanged[100];
extern char displayLog[20][40];
extern unsigned char displayLoc;
extern char indexLastMsg[0x800];

//extern unsigned char battData[256]; // 
extern unsigned char battData[BatDataBufMax]; // BatDataBufMax

extern bool showCP;
extern bool logEn;
extern bool yesBattLog; // gg - Batt Log
extern bool repeatPoll;
extern unsigned char dMode[2];
extern unsigned char lastDMode[2];
extern unsigned char sMode;
extern TOUCH_TFTx2 tt;
extern unsigned char dtMode;
extern float accV;
extern bool playbackEn;
extern bool playbackOpen;
extern float playbackInt;
extern float kW[39];
extern float mpkWh[39];
extern unsigned char whichTouched;
extern unsigned char skin;
extern unsigned char dtePeriod;
extern bool updateDTE;
extern unsigned char tNavRow; // gg - 4x4
extern unsigned short pointerSep; // log write buffer pointer separation
extern unsigned char battTemp_x4;
extern bool metric;

extern "C" {
    void printLast (bool force, bool showButtons);
    void printChanged (bool force, bool showButtons);
    void printLog (bool force, bool showButtons);
    void mainDisplay (bool force, bool showButtons);
    void dteDisplay (bool force, bool showButtons, bool showMiles);
    void braking (bool force, bool showButtons, bool prdata);
    void cpData(bool force, bool showButtons);
    void cpHistogram(bool force, bool showButtons); // gg - hist
    void cpBarPlot(bool force, bool showButtons); // gg - cpbars
    void showIndex(bool force, bool showButtons); // gg - index
    void showDateTime(bool force, bool showButtons);
    void updateDisplay(char display);
    void showButton(unsigned char column, unsigned char row, char * text1, char * text2, unsigned char columns, unsigned char rows);
    void highlightButton(unsigned char column, unsigned char row, unsigned char tScn, unsigned char columns, unsigned char rows);
    float convertDistance(float input); // LM - Metric
    float convertTemperature(float input); // LM - Metric
    char* distanceUnit(); // LM - Metric
    char* temperatureUnit(); // LM - Metric
}