//https://os.mbed.com/handbook/RTOS

#include "mbed.h"


#define NUMBER_OF_TASKS 7
#define STACK_SIZE      512


Thread tasks[NUMBER_OF_TASKS]={
        Thread(osPriorityNormal, STACK_SIZE, NULL,"t1"),
        Thread(osPriorityNormal, STACK_SIZE, NULL,"t2"),
        Thread(osPriorityNormal, STACK_SIZE, NULL,"t3"),
        Thread(osPriorityNormal, STACK_SIZE, NULL,"t4"),
        Thread(osPriorityNormal, STACK_SIZE, NULL,"t5"),
        Thread(osPriorityNormal, STACK_SIZE, NULL,"t6"),
        Thread(osPriorityNormal, STACK_SIZE, NULL,"t7")
    };

Serial pc(USBTX, USBRX);

inline void blockingWait(){
    for(uint32_t i = 0; i < 5000000; i++);
}


void blink(void * data){
    uint32_t a = 0;
    while(1)
    {
       pc.printf("Task: data = %d a = %d\n",(char *)data, a++);
       a += (uint32_t)((char *)data);
       blockingWait();
    }
}

void initTasks();

int main(){
    pc.baud(115200);
    initTasks();
    
    while(1){
    pc.printf("Task list\n");
    pc.printf("Task Name\tMem Used\tTotal Memory\n");
    for(uint8_t i = 0; i < NUMBER_OF_TASKS; i++)
        pc.printf("%s\t%d\t%d\n",
            (tasks[i].get_name())?tasks[i].get_name():"no name",
            tasks[i].used_stack(),
            tasks[i].stack_size());
        
    wait(3);
    }
}


void initTasks(){
    char * data= 0;
    for(uint8_t i = 0; i < NUMBER_OF_TASKS; i++, data++)
        tasks[i].start(callback(blink, (void *)data));
}
    