#include "mbed.h"
#include "SHA256.h"
#include "rtos.h"
#include <stdlib.h>
#include <string>

Mutex NewKey_mutex;
Mutex NewMotorCommand_mutex; 
Mutex Music_mutex;

// Global Variable Shared between threads
float NewRotation; 
float NewSpeed; 
uint64_t NewKey;

bool NewSpeed_flag;
bool NewRotation_flag;

#include "SerialCommunication.h"
#include "CryptoMining.h"
#include "MotorControl.h"


 


// Declaration of threads
Thread thread_crypto;
Thread thread_processor;

// Timing variables for printing calculation rate
Timer timer_nonce;
uint32_t previous_time;

//Main
int main()
{
    pc.attach(&serialISR);

    // Initialize threads and timers
    timer_nonce.start();
    thread_crypto.start(thread_crypto_print);
    thread_processor.start(thread_processor_callback);
    //NewSpeed = 30;
    //thread_motorCtrl.start(&NewSpeed, motorCtrlFn);
        
    uint8_t hash[32];

    while (1) {
        //Luccas' Code until we can move rest into seperate thread
    
        NewMotorCommand_mutex.lock();

         pc.printf("Thread  Actual %d\r\n", thread_motorCtrl.get_state());
         pc.printf("Thread state Expected %d\r\n",Thread::Running);
         
        
        
        if(NewSpeed_flag && thread_motorCtrl.get_state() != Thread::Deleted){
            pc.printf("Ending Previous Thread");
            thread_motorCtrl.terminate();
        }
        
        if(NewSpeed_flag){
            pc.printf("starting thread");
            thread_motorCtrl.start(&NewSpeed, motorCtrlFn);
            NewSpeed_flag = false;
        }
        
        NewMotorCommand_mutex.unlock();
    
        wait(1);

        // Set main as lowest priority thread
        NewKey_mutex.lock();
        *key = NewKey;
        NewKey_mutex.unlock();

        SHA256::computeHash(hash, (uint8_t *)sequence, 64);
        *nonce = *nonce + 1;

        if ((hash[0] == 0) && (hash[1] == 0)) {
            last_nonce_number = successful_nonce;
            putMessageCrypto(*nonce);
            successful_nonce++;
        }

        if ((timer_nonce.read_ms() - previous_time) > 1000) {
            //pc.printf("Computation Rate: %lu computation /sec\n\r", (*nonce - last_nonce_number));
            last_nonce_number = *nonce;
            previous_time = timer_nonce.read_ms();
        }
    }

    return 0;
}