
// Serial port variables
std::string buffer_serial = ""; 
RawSerial pc(USBTX, USBRX);
char command_category;
Mail<uint8_t, 8> inCharQ;

// Serial port methods

// Decode characters in the serial buffer
void decode_serial_buffer(std::string serial_buffer); 
// Thread that receives character one by one until \r is received
void thread_processor_callback(); 
// ISR -  Interrupt service routine for the Serial communication
void serialISR(); 


void decode_serial_buffer(std::string serial_buffer)
{   
    command_category = serial_buffer[0]; 
    switch (command_category)
    {
    case 'R':
        // Rotation command - R-?\d{1,s4}(\.\d)?
        NewMotorCommand_mutex.lock(); 
        sscanf(serial_buffer.c_str(), "%c %f", &command_category, &NewRotation); 
        pc.printf("You have a new rotation: %f \r\n", NewRotation);
        NewMotorCommand_mutex.unlock(); 

        break;
    case 'V':
        // Speed command - V\d{1,3}(\.\d)?
        NewMotorCommand_mutex.lock();
        sscanf(serial_buffer.c_str(), "%c %f", &command_category, &NewSpeed); 
        pc.printf("You have a new speed: %f \r\n", NewSpeed);
        NewSpeed_flag = true;
        NewMotorCommand_mutex.unlock(); 
        // to implement !
        break;

    case 'K':
        // Bitcoin key command - K[0-9a-fA-F]{16}
        NewKey_mutex.lock();
        sscanf(serial_buffer.c_str(), "%c %llx", &command_category, &NewKey); 
        pc.printf("You have entered a new bitcoin key: %llu \r\n",(long long) NewKey);
        NewKey_mutex.unlock();
        break;

    case 'T':
        // Melody command - T([A-G][#^]?[1-8]){1,16}
        Music_mutex.lock();
        pc.printf("You have entered a new melody: --> TO IMPLEMENT <--- \r\n");
        Music_mutex.unlock(); 
        // to implement !
  
    default:
        printf("Input value out of format - please try again! \r\n");
    }
}

// Thread processor raw serial inputs:
void thread_processor_callback()
{
    while (true)
    {
        osEvent evt = inCharQ.get();
        uint8_t *newChar = (uint8_t *)evt.value.p;
        buffer_serial += (*newChar); 
        //Store the new character
        if (buffer_serial.back() == '\r')
          {
            buffer_serial += '\0';
            decode_serial_buffer(buffer_serial);
            buffer_serial = ""; 
            }
        inCharQ.free(newChar);
    }
}

void serialISR()
{   
    uint8_t *newChar = inCharQ.alloc();
    *newChar = pc.getc();
    inCharQ.put(newChar);
}