// Crypto mining variables
uint8_t sequence[] = {0x45, 0x6D, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64,
                      0x20, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6D, 0x73,
                      0x20, 0x61, 0x72, 0x65, 0x20, 0x66, 0x75, 0x6E,
                      0x20, 0x61, 0x6E, 0x64, 0x20, 0x64, 0x6F, 0x20,
                      0x61, 0x77, 0x65, 0x73, 0x6F, 0x6D, 0x65, 0x20,
                      0x74, 0x68, 0x69, 0x6E, 0x67, 0x73, 0x21, 0x20,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
uint64_t *key = (uint64_t *)&sequence[48];
uint64_t *nonce = (uint64_t *)&sequence[56];
uint32_t successful_nonce = 0;
uint32_t last_nonce_number = 0;
uint8_t hash[32];
Mail<uint64_t, 16> crypto_mail;


// Function declartion: 
// Thread that prints the successful nonces
void thread_crypto_print(); 
// Adds email with successful nonce to Mailbox to be retrieved by thread_crypto_print()
void putMessageCrypto(uint64_t nonce); 

// Thread to print successful Hashes
void thread_crypto_print()
{
    while (true)
    {
        osEvent evt = crypto_mail.get();
        if (evt.status == osEventMail)
        {
            uint64_t *matching_nonce = (uint64_t *)evt.value.p;
            pc.printf("Matching nonce found: %llu \n\r",(long long) *matching_nonce); 
            crypto_mail.free(matching_nonce);
        }
    }
}

// Put message in Mail box for Crypto printing
void putMessageCrypto(uint64_t nonce)
{
    uint64_t *mail = crypto_mail.alloc();
    *mail = nonce; 
    crypto_mail.put(mail);
}

