/*
RobotCup ENS Paris Saclay 2020-2021
Team FC Furious
Code by Luc DERRIEN

Programme communication PC-Robot
Point de vue : robot
micro controleur : L475

reception d'une chaine de caractère de taille TRANSFER_SIZE = 20
forme : id_robot, v_tangent, v_normale, omega_robot, spiner_bool, v_tir
 - id_robot : 1 ou 2 (taille 1)
 - v_tangent : 0000 à 9999 (taille 4)
 - v_normale : 0000 à 9999 (taille 4)
 - omega_robot : 0000 à 9999 (taille 4)
 - spiner_bool : 0 ou 1 (taille 1)
 - v_tir = 1 à 9 (taille 1)
*/

#include "mbed.h"
#include "nRF24L01P.h"

Serial pc(USBTX, USBRX); // tx, rx

//Définition des E/S de la liaison SPI vers le module nRF24L01+
nRF24L01P my_nrf24l01p(D11, D12, D13, D9, D2, D1);    // mosi, miso, sck, csn, ce, irq

int main() {

// Nombre de caractères transmis à chaque envoi
#define TRANSFER_SIZE   20

    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    int txDataCnt = 0;
    int rxDataCnt = 0;
    int id_robot, v_tangent, v_normale, omega_robot, spiner_bool, v_tir ;
    int consigneData[6];
    
    pc.baud(115200); // Débit de la liaison série PC

    
    my_nrf24l01p.powerUp();
    
    my_nrf24l01p.setRfFrequency(2416); // Définition de la fréquence du canal d'E/R
    my_nrf24l01p.setAirDataRate(NRF24L01P_DATARATE_1_MBPS); // Définition du débit de la communication RF
    

    // Affichage de l'état de la configuration du nRF24L01+ 
    pc.printf( "_______________________\r\nCarte robot 1 :\r\n_______________________\r\n" );
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() ); 
    

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    

    while (1) {

        // If we've received anything in the nRF24L01+2...
        if ( my_nrf24l01p.readable() ) {
            
            // ...read the data into the receive buffer
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
            if(sscanf(rxData, "%d,%d,%d,%d,%d,%d",&id_robot,&v_tangent,&v_normale,&omega_robot,&spiner_bool,&v_tir)==6){ // lecture et parsing de la chaîne
            
            consigneData[0] = id_robot;
            if (v_tangent > 999) {
                v_tangent = - (v_tangent - 1000);
                }
            consigneData[1] = v_tangent;
            
            if (v_normale > 999) {
                v_normale = - (v_normale - 1000);
                }
            consigneData[2] = v_normale;
            
            if (omega_robot > 999) {
                omega_robot = - (omega_robot - 1000);
                }
            consigneData[3] = omega_robot;
            
            consigneData[4] = spiner_bool;
            consigneData[5] = v_tir; }
            
            rxDataCnt = 0;


        }
        
    }
}
