#include "mbed.h"
#include "tmp.h"
//reused code from miniproject day 7. Not reinventing the wheel. 


//Code for Temperature Sensor
I2C * tempsensor;

void temp_init(){
    tempsensor = &connection;
    char config_t[3];
    config_t[0]=0x01;
    config_t[1]=0x60;   //configures data byte 1
    config_t[2] = 0xA0; //configures data byte 2
    tempsensor->write(temp_addr, config_t,3);
    config_t[0]=0x00;
    tempsensor->write(temp_addr, config_t,1);
}
float get_temp(){
        pc.printf("in call to temp\r\n");
        float temp;
        char temp_read[2];
        wait(0.05); //shorter wait time
        tempsensor->read(temp_addr, temp_read, 2);
        
        temp = 0.0625*(((temp_read[0]<<8))+temp_read[1]>>4);//calculate and convert data
        #ifdef DEBUG_MODE
        pc.printf("Temp = %.2f degC\n\r", temp);
        #endif
        return temp;
}

// gets the average of n (default 5) temperature readings
float get_avg_temp(int n){
    if (n <= 0)
        return 0;
    float count = 0;
    for (int i = 0; i < n; i++){
        count += get_temp();    
    }
    return count / n;       
}

