/*
*  Compass I2C interface header file
*  Laura Delaney
*  1/11/2017
*/

#ifndef COMPASS_H_
#define COMPASS_H_

extern I2C connection;
//initialize the sensor to single measure mode
void compass_init();
//calculates the heading from the data, prints the heading if DEBUG_MODE is defined
float calc_heading(short mags[3], float declination); //x, z, y
//gets the heading, adjusted for the given declination
float get_heading(float declination); //spokane is +14.85 and getting smaller
//gets the average of n readings. If n is not given, averages 5 readings
float get_avg_heading(float declination, int n = 5);

#endif
