#include "mbed.h"
#include "acc.h"
#include "tmp.h"
#include "display.h"
#include "compass.h"


DigitalOut myled(LED1);
I2C connection(p9, p10);
Serial pc(USBTX, USBRX);
PinName dataBus[]= {p30, p29, p28, p27, p26, p25, p24, p23}; 
ILI932x myLCD(BUS_8, dataBus, p15, p17, p16, p14, p20, "myLCD", 240, 320); // Bus 8 bit, bus pin array, CS, RST, DC, WR, RD, name, xpixels, ypixels
extern DmTouch touch(DmTouch::DM_TFT24_104, p5, p6, p7, p8, p11);
Ticker tDisplay;
Ticker tTouch;
bool  a, t, c;

int main() {
    touch.init(); //initialize all connections
    temp_init();
    acc_init();
    compass_init();
    a = false; //set the global flag variables to start false
    t = false;
    c = false;
    tDisplay.attach(&display, 10); //10s ticker, per spec, controls the display
    tTouch.attach(&update_touch, 0.07); //.07s ticker, updates the flags for what is selected
    while(1) { //loop doing nothing
        }
}

bool in_A(int x, int y){
    //circle: 150, 100 | r = 40
    x -= 150;
    y -= 100;
    if (x*x + y*y < 40*40)
        return true;
    else
        return false;
}

//check if coord is in T's circle
bool in_T(int x, int y){
    //circle: 40, 100 | r = 40
    x -= 40;
    y -= 100;
    if (x*x + y*y < 40*40)
        return true;
    else
        return false;
}

bool in_C(int x, int y){
    //circle: 260, 100 | r = 40
    x -= 260;
    y -= 100;
    if (x*x + y*y < 40*40)
        return true;
    else
        return false;
}

