#include "mbed.h"
#include "acc.h"
#include "display.h"
#include "DmTouch.h"
#include "lcd_prompts.h"
#include "game.h"
#include <sstream>
#include "Song.h"

DigitalOut gpo(D0);
DigitalOut led(LED_RED);
DigitalOut led_blue(LED_BLUE);
DigitalOut led_green(LED_GREEN);
I2C connection(D14, D15);
InterruptIn acc_int(D8);
PinName dataBus[] = {PTC16, PTC17, PTB9, PTA1, PTB23, PTA2, PTC2, PTC3};
ILI932x myLCD(BUS_8, dataBus, PTB18, PTB19, PTC1, PTC8, PTC9, "myLCD", 240, 320);
DmTouch touch(DmTouch::DM_TFT24_104, PTD2, PTD3, PTD1, PTC0, PTC7);
PwmOut myBuzzer(A5);

Timeout read_again;
int num_choices_global;
int prompt_input_val;
Serial pc(USBTX, USBRX);
bool waiting_for_touch;
int num_players;
int current_player;
int current_player_index;
Timer current_clock;
vector<float> player_timers;
vector<int> player_order;
float bonus_time;
Timeout time_before_warning;
Timeout time_after_warning;
Song * jeopardy, * scale, * beep;
Timeout note_duration;
bool clock_running;
int step_number;

void setup();

int main()
{
    setup();
    pc.printf("completed setup\r\n");
    //jeopardy->play();
    int n;
    while (true) {
        display_timer();
        if (waiting_for_touch == false){
            //the only time we hit this point in main is while waiting for the next step
            next_step(); //next_step will take care of pausing the timers
        }
        else {//waiting_for_touch is true
           //pc.printf("waiting for x\r\n");  //used for debugging
        }
        led = !led; // toggle led
        if (acc_int){
            int buf = get_int_type();
            if (buf == 1){
                toggle_pause();
                led_green = !led_green;
            }
            else if (buf == 2){
                next_player();
                display_timer();
                led_blue = !led_blue;   
            } 
        }
        wait(0.2f);
        pc.printf("completed a loop through main \r\n");
        wait(0.2f);
    }
}

void setup(){
    acc_init( 10 , 0.5 , 6 , 318.75 );  
    led_blue = 1;
    led_green = 1;
    touch.init();
    touch.setOrientation(3);
    display_init();
    prompt_init();
    waiting_for_touch = false;
    game_setup();
}