#ifndef GAME_H
#define GAME_H
#include "mbed.h"
#include <vector>
#include "lcd_prompts.h"
#include <sstream>
#include <algorithm> //reverse
#include "Song.h"

extern int num_players;
extern int current_player;
extern int current_player_index;
extern Timer current_clock;
extern bool clock_running;
extern vector<float> player_timers;
extern vector<int> player_order;
extern float bonus_time;
extern int phase_number;
extern int step_number; //0 = set turn order, 1 = auction power plants, 2 = buy resources, 4 - building, 5 = beauracracy
const float time_after_warning_sound = 15; //after 15 seconds of a turn, play jeopardy
extern Timeout time_after_warning;
const float time_before_warning_sound = 60; //when the timer has 60 seconds left, play a scale
extern Timeout time_before_warning;
extern Song * jeopardy, * scale, * beep;
extern Serial pc;

void game_setup();
void init_num_players();
void set_player_order();
void set_start_time(); //right now this has hardcoded options
void set_bonus_time(); //right now this also has hardcoded options

void next_step();
void reverse_player_order();

void display_timer();
void update_clock();
void update_timer();
void next_player();
void start_timer(int player_num);
void pause_timer();
void unpause_timer();
void toggle_pause();






#endif
