#include "acc.h"


void acc_init(float duration, float threshold, float gap, float window){
    //acc = &connection;
    char durationByte, thresholdByte, gapByte, windowByte; 
    
    //convert the function parameters from their respective units to the appropriate byte values
    durationByte = duration / 0.625;
    thresholdByte = threshold / 0.00625;
    gapByte = gap / 1.25;
    windowByte = window / 1.25;
    
    //set the config constants
    char acc_config_dataFormat[2] = {0x31,0x0b}; //measurement range
    char acc_config_powerControl[2] = {0x2d,0x08};
    char acc_config_tapThreshold[2] = {0x1d,thresholdByte};
    char acc_config_tapDuration[2] = {0x21,durationByte};
    char acc_config_latentGap[2] = {0x22,gapByte};
    char acc_config_window[2] = {0x23,windowByte};
    char acc_config_enableAxis[2] = {0x2a,0x07};
    char acc_config_intEnable[2] = {0x2e,0x60};
    char acc_config_intMap[2] = {0x2f,0x60};
    
    //set the configuration
    connection.write(addr_acc, acc_config_dataFormat, 2); //full measurement range
    wait(.05);
    connection.write(addr_acc, acc_config_tapDuration, 2);
    wait(.05);
    connection.write(addr_acc, acc_config_tapThreshold, 2);
    wait(.05);
    connection.write(addr_acc, acc_config_latentGap, 2);
    wait(.05);
    connection.write(addr_acc, acc_config_window, 2);
    wait(.05);
    connection.write(addr_acc, acc_config_enableAxis, 2);
    wait(.05); 
    connection.write(addr_acc, acc_config_intEnable, 2);
    wait(.05);
    connection.write(addr_acc, acc_config_intMap, 2);
    wait(.05);
     connection.write(addr_acc, acc_config_powerControl, 2); // measure mode
    wait(.05);
}

char get_int_type(){
    char int_source_arr[2] = {0x30|0x80, 0x00};
    connection.write(addr_acc, int_source_arr, 1); //set up the connection for reading from int_source
    char acc_data[1];
    connection.read(addr_acc, acc_data, 1); //read the int_source byte
    //pc.printf("%x\t",acc_data[0]&0x60); //this was used for debugging
    if(acc_data[0] & 0x20) //if a double tap, return 2
        return 2;
    else if (acc_data[0] & 0x40) //if a single tap, return 1
        return 1;
    //this code should never be reached, but is included so that there is an appropriate exit path   
    return 0;
}