#ifndef SONG_H
#define SONG_H
#include<vector>
#include "mbed.h"
extern PwmOut myBuzzer;
extern Timeout note_duration;
extern DigitalOut led;
extern Serial pc;

class Song{
protected: 
    float beat_length;
public: 
    vector<float> freqs;
    vector<float> beats;
    //int * freqs;
    //int * beats;
    int song_length;
    int place_in_song;   
     
    Song(vector<float> &freq, vector<float> &beat, int length, int tempo){ //length format left over from int arrays. Had pointer issues. Replaced with vectors. 
        pc.printf("In song constructor with length %d\r\n", length);
        if (tempo == 0) //prevent divide by zero runtime errors
            tempo = 120;
        beat_length = 60.0/tempo; //beats/minute -> beat duration in seconds
        pc.printf("Beat length is %.2fs\r\n", beat_length);
        freqs = freq;
        beats = beat;
        song_length = length;
        place_in_song = 0;
        return;
    }
    
    void play();
    void set_note(int index);
    void set_tempo(int tempo);
};

#endif