#include "Song.h"

void mute(){
    note_duration.detach();
    myBuzzer = 0;    
}

void Song::play(){
        if (place_in_song < song_length){
            set_note(place_in_song);
            note_duration.attach(this, &Song::play, beat_length*beats[place_in_song]);
            place_in_song++;
        }
        else{
            mute();
            place_in_song = 0;
        }
    }
    
    void Song::set_note(int index){
        myBuzzer.period(1/(2*freqs[index]));
        myBuzzer = 0.5;
    }
    
    void Song::set_tempo(int tempo){
        beat_length = 60.0/tempo;
    }