#include "mbed.h"
#include <Pulse1.h>
#include "TextLCD.h"

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
PulseInOut irda(PTD5);//  puerto sensor infrarrojo
Serial pc(USBTX, USBRX);
PwmOut led(LED1);
PwmOut Salida(PTA4);
float perro=1;

int header =0; //tiempo de cabecera pulso abajo
const int head_H = 11040; //+20% medida con osciloscopio en microsegundos
const int head_L = 7360;//-20%  medida con osciloscopio
int i=0;
const int T_alto=1560;//ponga su tiempo de la prueba
const int T_bajo=480;//ponga su tiempo de la prueba
const int num_bits = 32;//ponga su numero de bits
int num[num_bits];//cadena para almacenar todos los tiempos que conforman los bits de datos
int sec[num_bits];//cadena para almacenar la cadena codificada en binario
int boton1[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,0,1,1,0};
int boton2[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,0,1,0,0,1,0,0,0,1,0,1,1,0,1,1,0};
int flag1,flag2,flag3; //Banderas tiempo
int dato; // tiempo de cada dato que se lee

int main()
{
    led=1;
    while(1)
    {
ini1:
        header=0;
        header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo
        if (header > head_L && header < head_H) goto seguir;//verificar que este en la tolerancia +-20%
        else goto ini1;

seguir:
        //leo los datos de la trama y se meten a un arreglo
        wait_us(2000);
        for(i=0; i<(num_bits-1); ++i) // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
        {
            dato = irda.read_high_us(); //leer un bit de datos que es pulso arriba en este control
            num[i]=dato;
            wait_us(332);
        }
        //wait(0.5); //espero un poquito antes de leer todo el arreglo y ponerlo en pantalla
        pc.printf(",%d",header);
        for(i=0; i<num_bits; ++i)
        {
            pc.printf(",%d",num[i]);
        }
        //wait(0.1);  //espero e imprimo en binario
        pc.printf("\n\n");
        for(i=0; i<num_bits; ++i)
        {
            if(num[i] > ((T_alto+T_bajo)/2))
            {
                pc.printf("1");
                sec[i]=1; // guardo la secuancia en binario
            }
            else
            {
                sec[i]=0; //guardo la secuencia en binario
                pc.printf("0");
            }
        }

        flag1=1;
        flag2=1;
        flag3=1;
        for(i=0; i<32; ++i)
        {
            if(sec[i]!=boton1[i]) //en caso de que un bit no coincida se descarta el boton 1
            {
                flag1=0;
            }
            if(sec[i]!=boton2[i]) //en caso de que un bit no coincida se descarta el boton 2
            {
                flag2=0;
            }
        }
        if(flag1==1)
        {
            if(perro<1){
                perro=perro+0.1;
                Salida=perro;
                led=perro;
                lcd.cls(); // Borrar Pantalla
                lcd.locate(0,0);
                lcd.printf("perro=%g",perro); }//si coincidieron todos los bits del boton 1
            
        }
        else if(flag2==1)
        {
            if(perro>0.1){
                perro=perro-0.1;
                Salida=perro;
                led=perro;
                lcd.cls(); // Borrar Pantalla
                lcd.locate(0,0);
                lcd.printf("perro=%g",perro); }//si coincidieron todos los bits del boton 2
        }
        
    }
}
