#include "mbed.h"
#include "MMA8451Q.h" // libreria del acelerometro
#include "TextLCD.h"0
#define MMA8451_I2C_ADDRESS (0x1d<<1) 
 
int main(void) {
    TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS); // puerto del acelerometro
    PwmOut rled(LED_RED); // se declara como PWM para  la asignacion de valores intermedios
    PwmOut gled(LED_GREEN);
    PwmOut bled(LED_BLUE);
 
    while (true) {
        lcd.locate(0,0);lcd.printf("      "); // Posiciones de las pantallas
        lcd.locate(0,0);lcd.printf("X=%g",acc.getAccX());// 
        lcd.locate(8,0);lcd.printf("    ");
        lcd.locate(8,0);lcd.printf("Y=%g",acc.getAccY());
        lcd.locate(0,1);lcd.printf("    ");
        lcd.locate(0,1);lcd.printf("Z=%g",acc.getAccZ());
        rled = 1.0 - abs(acc.getAccX());// obtención de las coordenadas
        gled = 1.0 - abs(acc.getAccY());// obtención de las coordenadas
        bled = 1.0 - abs(acc.getAccZ());// obtención de las coordenadas
        
        wait(0.3);
    }
}
 