#include <stddef.h>
#include <cmath>
#include <string.h>
#include "rtwtypes.h"

#define ny 1
#define nu 1

#define nx 3

// Block signals and states (auto storage) for system '<Root>'
typedef struct {
  real_T uk_1[nu];                      // '<Root>/Data Store Memory2'
  real_T duk_1[nu];                     // '<Root>/Data Store Memory4'
} DWg;

// External inputs (root inport signals with auto storage)
typedef struct {
  real_T sp[ny];                        // '<Root>/sp'
  real_T x[nx];                         // '<Root>/y'
} ExtUg;

// External outputs (root outports fed by signals with auto storage)
typedef struct {
  real_T u[nu];                         // '<Root>/u'
  real_T du[nu];
} ExtYg;


// Class declaration for model MPC_R
class MPC_Gen {
  // public data and function members
 public:
  // External inputs
  ExtUg rtU;

  // External outputs
  ExtYg rtY;

  // model initialize function
  void initialize();

  // model step function
  void step();
  
  void matr_mult(int_T n1, int_T n2,int_T n3, real_T **A,real_T **B, real_T **R);
    
  void eye(int_T n, real_T **R);
  
  void matr_sum(int_T n1,int_T n2, real_T **A,real_T **B, real_T **R);
  
  void matr_dif(int_T n1,int_T n2, real_T **A,real_T **B, real_T **R);
  
  void matr_t(int_T n1,int_T n2,real_T **A, real_T **R);
  
  void mvec_mult(int_T n1,int_T n2,real_T **A,real_T *B, real_T *R);
  
  void mvec_multl(int_T n1,int_T n2,real_T *B,real_T **A, real_T *R);
  
  // Wikipedia LUP decomposition routines and inverse, perhaps use LUP solve? Gotta try
  int LUPDecompose(double **A, int N, double Tol, int *P);
  
  void LUPInvert(double **A, int *P, int N, double **IA);
  
  // Constructor
  MPC_Gen(int_T mi, int_T pi, real_T (&qi)[ny], real_T (&ri)[nu], real_T (&umaxi)[nu], real_T (&umini)[nu], real_T dumax);
  
  // Destructor
  ~MPC_Gen();

  // private data and function members
 private:
  // Block signals and states
  DWg rtDW;
  
  const int_T m;
  const int_T p;
  const real_T (&q)[ny];
  const real_T (&r)[nu];
  const real_T (&umax)[nu];
  const real_T (&umin)[nu];
  const real_T dumax;
  
  //MPC_R(ys,y,Psi, Qbar, Thetabar, Itil, Dumax, Umin, Umax, H, nu, Mtil, m, p)
  real_T** H;
  real_T** Qbar;
  real_T** Thetabar;
  real_T** Psi;
  real_T** Mtil;
  real_T** Itil;
  real_T** Ac;
  real_T* Dumax;
  real_T* Umin;
  real_T* Umax;
  real_T** Hinv;
  real_T** nHinv;
  real_T** nHinvtAc;
  real_T** Qtheta;
  
  //real_T** tItil;
  
  real_T** P;
  real_T* bc;
  
};
