#include "MPCG.h"
#define NumBitsPerChar                 8U
#include "mbed.h"
#include "model.h"

// Model step function
void MPC_Gen::step()
{
    /*
    Serial pc (USBTX,USBRX);        // Inicia serial
    wait(0.1);
    pc.baud(115200);
    wait(0.1);
    */
    /*
    for (int i = 0; i < nu*m; i++)
    {
        for (int j = 0; j < nu*m; j++)
        {
           pc.printf("%f ",Hinv[i][j]);
        }
           pc.printf("\n\r");
    }
    */
    // Calcula ymk e xmk
    real_T xmk[nx];

    for (int i = 0; i < nx; i++) {
        xmk[i] = rtU.x[i];
    }


    /*
    for (int i = 0; i < nx; i++) {
        pc.printf("%f\n\r",xmk[i]);
    }
    pc.printf("\n\r");
    */

    real_T ysp[p*ny];
    // calcula ysp
    /* for (int i = 0; i < p; i++){
    ysp[((1 + i) << 1) - 2] = rtU.sp[0];
    ysp[((1 + i) << 1) - 1] = rtU.sp[1];
    } */ // Apenas se tiver 2 set-points
    for (int i = 0; i < p; i++) {
        ysp[i] = rtU.sp[0];
    }

    /*
    for (int i = 0; i < p*ny; i++) {
        pc.printf("%f\n\r",ysp[i]);
    }
    */
    // calcula ct
    real_T* el = new real_T[p*ny];
    mvec_mult(p*ny,nx,Psi,xmk,el);

    for (int i = 0; i < ny*p; i++) {
        el[i] = el[i]-ysp[i];//-el por causa de ct
    }
    /*
    for (int i = 0; i < p*ny; i++) {
        pc.printf("%f\n\r",el[i]);
    }
    */
    real_T* ct = new real_T[m*nu];

    /*
    for (int i = 0; i < ny*p; i++)
    {
        for (int j = 0; j < nu*m; j++)
        {
           pc.printf("%f ",Qtheta[i][j]);
        }
           pc.printf("\n\r");
    }
    */


    mvec_multl(p*ny,m*nu,el,Qtheta,ct);

    /*
    for (int i = 0; i < m*nu; i++) {
        pc.printf("%f\n\r",ct[i]);
    }
    */

    // calcula bc
    real_T* uk_1 = new real_T[nu];
    for (int i = 0; i < nu; i++) {
        uk_1[i]=rtDW.uk_1[i];
    }

    real_T* bc_int = new real_T[m*nu];

    mvec_mult(m*nu,nu,Itil,uk_1,bc_int);

    //bc=[Umax-Itil*uk_1;-Umin+Itil*uk_1;Dumax;Dumax];
    bc = new real_T[4*nu*m];

    for ( int i = 0; i < 4*nu*m; i++) {
        if(i < nu*m)
            bc[i] = Umax[i]-bc_int[i];
        else if (i < 2*nu*m)
            bc[i] = -Umin[i-nu*m]+bc_int[i-nu*m];
        else if (i < 3*nu*m)
            bc[i] = Dumax[i-2*nu*m];
        else if (i < 4*nu*m)
            bc[i] = Dumax[i-3*nu*m];
    }
    /*
    for (int i = 0; i < m*nu; i++) {
        pc.printf("%f\n\r",bc_int[i]);
    }*/
    /*
    for (int i = 0; i < 4*m*nu; i++) {
        pc.printf("%f\n\r",bc[i]);
    }
    */
    // Memory Deallocation
    delete [] el;
    delete [] uk_1;
    delete [] bc_int;
    el = 0;
    uk_1 = 0;
    bc_int = 0;

    // solve QP
    // Unconstrained solution
    real_T* x_un = new real_T[m*nu];
    real_T* x_c = new real_T[m*nu];
    real_T* x = new real_T[m*nu];

    mvec_mult(m*nu,m*nu,nHinv,ct,x_un);

    for(int i = 0; i < m*nu; i++) {
        x[i] = x_un[i];
    }

    /*
    for (int i = 0; i < m*nu; i++) {
        pc.printf("%f\n\r",x_un[i]);
    }
    */

    int_T kk = 0;
    real_T aci = 0;

    for (int i = 0; i < 4*m*nu; i++) {
        aci = 0;
        for(int j = 0; j < m*nu; j++) {
            //A_cons(i,:)*eta>b(i)
            aci = aci+ Ac[i][j]*x_un[j];
        }
        if (aci > bc[i])
            kk++;
    }

    //pc.printf("%d\n\r",kk);


    real_T* d = new real_T[4*m*nu];
    if (kk != 0) {

        //d=(A_cons*(H\f)+b);
        mvec_mult(4*m*nu,m*nu,Ac,x_un,d);
        for (int i = 0; i < 4*m*nu; i++) {
            d[i] = -d[i];
        }
        /*
        for (int i = 0; i < 4*m*nu; i++) {
        pc.printf("%f\n\r",d[i]);
        }
        pc.printf("\n\r");
        */

        for( int i = 0; i < 4*m*nu; i++)
            d[i] = d[i] + bc[i];
        /*
        for (int i = 0; i < 4*m*nu; i++) {
        pc.printf("%f\n\r",d[i]);
        }
        pc.printf("\n\r");
        */
        //[n,ms]=size(d);
        //x_ini=zeros(n,ms);
        //lambda=x_ini;
        real_T lambda[4*m*nu];
        real_T lambdap[4*m*nu];
        for( int i = 0; i < 4*m*nu; i++) {
            lambda[i]=0;
        }

        int_T max_it = 100; // maximum solver iterations******************era 100
        int_T km = 0;
        real_T w = 0;
        real_T al = 0;
        //real_T normdif = 0;
        //real_T normbase = 0;

        while (km < max_it) {

            for(int i = 0; i < 4*m*nu; i++) {
                lambdap[i]=lambda[i];
            }
            km = km + 1;

            for(int i = 0; i < 4*m*nu; i++) {
                w = 0;
                //w= P(i,:)*lambda-P(i,i)*lambda(i,1);
                for(int j = 0; j < 4*m*nu; j++) {
                    w = w+ P[i][j]*lambda[j];
                }
                w = w - P[i][i]*lambda[i] + d[i];

                w = -w/P[i][i];
                if (w > 0)
                    lambda[i] = w;
                else
                    lambda[i] = 0;
            }

            /*
            normdif = 0;
            normbase = 0;

            for(int i = 0; i < 4*m*nu; i++){
                normdif = normdif + (lambda[i]-lambdap[i])*(lambda[i]-lambdap[i]);
                normbase = normbase + lambda[i]*lambda[i];
            }

            al = sqrt(normdif/normbase);//percentage error
            */

            al = 0;
            for(int i = 0; i < 4*m*nu; i++) {
                al = al + (lambda[i]-lambdap[i])*(lambda[i]-lambdap[i]);
            }

            /*
            if(al < 1e-7)
                km = max_it;
            */
            /*
            if(al < 1e-2)
                km = max_it;
            */
        }


        mvec_mult(m*nu,4*m*nu,nHinvtAc,lambda,x_c);
        for(int i = 0; i < m*nu; i++) {
            x[i] = x_un[i] + x_c[i];
        }
    }

    /*
    for (int i = 0; i < m*nu; i++) {
        pc.printf("%f\n\r",x[i]);
    }
    pc.printf("\n\r");
    */

    // Set outputs

    for (int i = 0; i < nu; i++) {
        rtDW.duk_1[i] = x[i];
        rtDW.uk_1[i] = x[i] + rtDW.uk_1[i];
        rtY.u[i] = rtDW.uk_1[i];
        rtY.du[i]= x[i];
    }


    // Deallocate Memory
    delete [] x;
    delete [] x_c;
    delete [] x_un;
    delete [] bc;
    delete [] ct;
    delete [] d;
    x = 0;
    x_c = 0;
    x_un = 0;
    bc = 0;
    ct = 0;
    d = 0;

    // Print control signal
    /*
    for (int i = 0; i < nu; i++) {
        pc.printf("%f\n\r",rtY.u[i]);
    }
    */



}

// Model initialize function
void MPC_Gen::initialize()
{
    /*
    Serial pc (USBTX,USBRX);        // Inicia serial
    wait(0.1);
    pc.baud(115200);
    wait(0.1);
    */
    for (int i = 0; i < nu; i++) {
        rtDW.uk_1[i] = 0;
        rtDW.duk_1[i]=0;
    }

    //pc.printf("%d %d %f %f %f %f %f %f %f %f %f \n\r",m,p,q[0],q[1],r[0],r[1],umax[0],umax[1],umin[0],umin[1],dumax);
    //int nphi = p*ny;


    // Identidade dimensão nx
    real_T** Inx = new real_T*[nx];//rows
    for (int i = 0; i < nx; i++) {
        Inx[i] = new real_T[nx];
    }

    eye(nx,Inx);

    real_T *A[nx];  // surrogate
    for (int i = 0; i < nx; i++) {
        A[i] = Ar[i];
    }

    int rows = nx, col=nu;
    real_T *B[rows];  // surrogate
    for (int i = 0; i < rows; i++) {
        B[i] = Br[i];
    }

    rows = ny, col=nx;
    real_T *C[rows];  // surrogate
    for (int i = 0; i < rows; i++) {
        C[i] = Cr[i];
    }

    // Initialize Aux1, Aux2, Aux1pow, Aux2pow
    rows = ny, col=nx;
    real_T** Aux1 = new real_T*[rows];//rows
    for (int i = 0; i < rows; i++) {
        Aux1[i] = new real_T[col];
    }
    rows = ny, col=nu;
    real_T** Aux2 = new real_T*[rows];//rows
    for (int i = 0; i < rows; i++) {
        Aux2[i] = new real_T[col];
    }
    rows = nx, col=nx;
    real_T** Aux1pow = new real_T*[rows];//rows
    for (int i = 0; i < rows; i++) {
        Aux1pow[i] = new real_T[col];
    }
    rows = nx, col=nx;
    real_T** Aux2pow = new real_T*[rows];//rows
    for (int i = 0; i < rows; i++) {
        Aux2pow[i] = new real_T[col];
    }

    rows = ny, col=nx;
    real_T** Aux3pow = new real_T*[rows];//rows
    for (int i = 0; i < rows; i++) {
        Aux3pow[i] = new real_T[col];
    }

    rows = p*ny, col=nu;
    real_T** ThA = new real_T*[rows];//rows
    for (int i = 0; i < rows; i++) {
        ThA[i] = new real_T[col];
    }

    rows = p*ny, col=nx;
    Psi = new real_T*[rows];//rows
    for (int i = 0; i < rows; i++) {
        Psi[i] = new real_T[col];
    }


    // Inicializa Aux1pow e Aux2pow como A e Inx

    matr_mult(nx,nx,nx,Inx,A,Aux1pow);
    matr_mult(nx,nx,nx,Inx,Inx,Aux2pow);


    for (int i = 0; i < p; i++) {
        if (i > 0) {
            //Aux1pow = dot_prod(Aux1pow,A);
            //Aux2pow = dot_prod(Aux2pow,A);

            matr_mult(nx,nx,nx,Aux1pow,A,Aux1pow);
            matr_mult(nx,nx,nx,Aux2pow,A,Aux2pow);
        }

        matr_mult(ny,nx,nx,C,Aux1pow,Aux1);

        matr_mult(ny,nx,nx,C,Aux2pow,Aux3pow);
        matr_mult(ny,nx,nu,Aux3pow,B,Aux2);

        for (int j = 0; j < ny; j++) { // ThA
            for (int k = 0; k < nu; k++)
                ThA[nu*i+k][j] = Aux2[k][j]; // 1º linha geral é nu*i+0/1/2... nu-1 outro for para caso geral
            //ThA[2*i+1][j] = Aux2[1][j]; // 2º linha
        }

        for (int j = 0; j < nx; j++) { // Phi
            for (int k = 0; k < ny; k++) {
                Psi[ny*i+k][j] = Aux1[k][j];// talvez zoe para outros casos de ny nu
            }
        }
        //pc.printf("oi5\n\r");
    }

    //pc.printf("%x",*(*(&Psi+1)+0));

    // Será que funciona?
    /*
    for (int i = 0; i < p*ny; i++)
    {
        for (int j = 0; j < nx; j++)
        {
           real_T & ref = Psi[i][j];//seria a Psi
           ref = Psi_in[i][j];//Seria a Psi_in
           delete &ref;
        }
    }*/


    /*
    for (int i = 0; i < p*ny; i++)
    {
        for (int j = 0; j < nx; j++)
        {
           pc.printf("%f ",Psi[i][j]);

        }
           pc.printf("\n\r");
    }*/
    //pc.printf("oi\n\r");

    // declarando matriz Thetabar de tamanho variável [rows][cols]
    rows = p*ny, col = m*nu;
    Thetabar = new real_T*[rows];
    for (int i = 0; i < rows; i++)
        Thetabar[i] = new real_T[col];


    // initialize thetabar with zeros
    for (int i = 0; i < ny*p; i++) {
        for (int j = 0; j < nu*m; j++) {
            Thetabar[i][j] = 0;
        }
    }
    // Montando a matriz dinâmica
    for(int j = 0; j < m; j++) {
        for(int k = 0; k < nu; k++) {
            for (int i = 0; i < ny*p; i++) {
                Thetabar[i][k+nu*j] = ThA[i][k];
            }
        }
        // começa de baixo
        for (int i = ny*p-1; i > ny-1; i--) { // caso particular para nu = ny = 2 //*********(int i = ny*p-ny+1; i > ny-1; i--)
            for (int k = 0; k < nu; k++)
                ThA[i][k] = ThA[i-ny][k];
        }


        for (int k = 0; k < nu; k++) {
            for (int i = 0; i < ny; i++)
                ThA[ny*j+i][k] = 0;
            //ThA[ny*j+1][k] = 0;
        }

    }
    /*
    pc.printf("oi\n\r");
    for (int i = 0; i < p*ny; i++)
    {
        for (int j = 0; j < nu*m; j++)
        {
           pc.printf("%f ",Thetabar[i][j]);

        }
           pc.printf("\n\r");
    }*/

    // Deallocation first part
    for (int i = 0; i < ny; i++) {
        delete [] Aux1[i];
        delete [] Aux2[i];
        delete [] Aux3pow[i];
    }
    delete [] Aux1;
    delete [] Aux2;
    delete [] Aux3pow;
    Aux1=0;
    Aux2=0;
    Aux3pow=0;

    for (int i = 0; i < nx; i++) {
        delete [] Aux1pow[i];
        delete [] Aux2pow[i];
        delete [] Inx[i];
    }
    delete [] Aux1pow;
    delete [] Aux2pow;
    delete [] Inx;
    Aux1pow=0;
    Aux2pow=0;
    Inx=0;

    for (int i = 0; i < p*ny; i++) {
        delete [] ThA[i];
    }
    delete [] ThA;
    ThA=0;

    // Montando Mtil
    // declarando matriz Mtil de tamanho variável [rows][cols]

    rows = nu*m, col=nu*m;
    Mtil = new real_T*[rows];//rows
    for (int i = 0; i < rows; i++) {
        Mtil[i] = new real_T[col];
    }
    for (int i = 0; i < nu*m; i++) {
        for (int j = 0; j < nu*m; j++) {
            Mtil[i][j] = 0;
        }
    }

    for (int i = 0; i < m; i++) {
        for (int j = 0; j < m*nu; j++) {
            if(nu*i+j < m*nu)
                Mtil[nu*i+j][j] = 1;
        }
    }


    // declarando matriz Ac de tamanho variável [rows][cols]
    rows = 4*m*nu, col = m*nu;
    Ac = new real_T*[rows];
    for (int i = 0; i < rows; i++)
        Ac[i] = new real_T[col];


    // Montando I(mu)
    // Identidade dimensão m*nu
    real_T** Imu = new real_T*[m*nu];//rows
    for (int i = 0; i < m*nu; i++) {
        Imu[i] = new real_T[m*nu];
    }
    eye(m*nu,Imu);


    // Montando Ac = [Mtil;-Mtil]
    //Ac.resize(nu*m,2*nu*m);
    for ( int i = 0; i < 4*nu*m; i++) {
        for ( int j = 0; j < nu*m; j++) {
            if(i < nu*m)
                Ac[i][j] = Mtil[i][j];
            else if (i < 2*nu*m)
                Ac[i][j] = -Mtil[i-nu*m][j];
            else if (i < 3*nu*m)
                Ac[i][j] = Imu[i-2*nu*m][j];
            else if (i < 4*nu*m)
                Ac[i][j] = -Imu[i-3*nu*m][j];
        }
    }
    /*
    for (int i = 0; i < 4*m*nu; i++)
    {
        for (int j = 0; j < nu*m; j++)
        {
           pc.printf("%f ",Ac[i][j]);

        }
           pc.printf("\n\r");
    }
    */

    rows = m*nu, col = nu;
    Itil = new real_T*[rows];
    for (int i = 0; i < rows; i++)
        Itil[i] = new real_T[col];

    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < col; j++) {
            Itil[i][j]=0;   //Set all elements to zero
        }
    }
    for (int j = 0; j < nu; j++) {
        for (int i = 0; i < m; i++) {
            if(nu*i+j < m*nu)
                Itil[nu*i+j][j] = 1;
        }
    }
    /*
    rows = nu, col = m*nu;
    tItil = new real_T*[rows];
    for (int i = 0; i < rows; i++)
        tItil[i] = new real_T[col];

    matr_t(m*nu,nu,Itil,tItil);
    */
    /*
    for (int i = 0; i < m*nu; i++)
    {
        for (int j = 0; j < nu; j++)
        {
           pc.printf("%f ",Itil[i][j]);

        }
           pc.printf("\n\r");
    }
    */
    // declarando matriz Qbar de tamanho variável [rows][cols]
    rows = p*ny, col = p*ny;
    Qbar = new real_T*[rows];
    for (int i = 0; i < rows; i++)
        Qbar[i] = new real_T[col];

    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < col; j++) {
            Qbar[i][j]=0;   //Set all elements to zero
        }
    }

    rows = m*nu, col = m*nu;
    real_T** Rbar = new real_T*[rows];
    for (int i = 0; i < rows; i++)
        Rbar[i] = new real_T[col];

    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < col; j++) {
            Rbar[i][j]=0;   //Set all elements to zero
        }
    }


    //Montando Qbar
    for( int j = 0; j < p; j++) {
        for (int i = 0; i < p; i++) {
            if(i == j) {
                for(int k = 0; k < ny; k++)
                    Qbar[ny*i+k][ny*j+k] = q[k];
            }
        }
    }
    //montando Rbar
    for (int i = 0; i < nu*m; i++)
        for(int j = 0; j < nu*m; j++)
            Rbar[i][j] = 0;


    for( int j = 0; j < m; j++) {
        for (int i = 0; i < m; i++) {
            if(i == j) {
                for(int k = 0; k < nu; k++)
                    Rbar[nu*i+k][nu*j+k] = r[k];
            }
        }
    }
    /*
    for (int i = 0; i < nu*m; i++)
    {
        for (int j = 0; j < nu*m; j++)
        {
           pc.printf("%f ",Rbar[i][j]);
        }
           pc.printf("\n\r");
    }
    */



    Dumax = new real_T[nu*m];
    Umin = new real_T[nu*m];
    Umax = new real_T[nu*m];

    for (int i = 0; i < nu*m; i++) {
        Dumax[i] = 0;
        Umax[i] = 0;
        Umin[i] = 0;
    }

    for (int i = 0; i < m; i++) {
        for (int k = 0; k < nu; k++) {
            Dumax[nu*i+k]=dumax;
            Umax[nu*i+k]=umax[k];
            Umin[nu*i+k]=umin[k];
        }
    }
    /*
    for (int i = 0; i < nu*m; i++)
    {
           pc.printf("%f \n\r",Dumax[i]);
    }
    for (int i = 0; i < nu*m; i++)
    {
           pc.printf("%f \n\r",Umax[i]);
    }
    for (int i = 0; i < nu*m; i++)
    {
           pc.printf("%f \n\r",Umin[i]);
    }
    */

    // declarando matriz H de tamanho variável [rows][cols]
    rows = m*nu, col = m*nu;
    H = new real_T*[rows];

    for (int i = 0; i < rows; i++)
        H[i] = new real_T[col];


    //H=Thetabar'*Qbar*Thetabar+Rbar;

    rows = m*nu, col = p*ny;
    real_T** tThetabar = new real_T*[rows];
    for (int i = 0; i < rows; i++)
        tThetabar[i] = new real_T[col];


    matr_t(p*ny,m*nu,Thetabar,tThetabar);
    matr_mult(m*nu,p*ny,p*ny,tThetabar,Qbar,tThetabar);
    matr_mult(m*nu,p*ny,m*nu,tThetabar,Thetabar,H);
    matr_sum(m*nu,m*nu,H,Rbar,H);


    rows = ny*p, col=m*nu;
    Qtheta = new real_T*[rows];//rows
    for (int i = 0; i < rows; i++) {
        Qtheta[i] = new real_T[col];
    }

    rows = m*nu, col=p*ny;


    matr_mult(ny*p,ny*p,m*nu,Qbar,Thetabar,Qtheta);

    /*
    for (int i = 0; i < nu*m; i++)
    {
        for (int j = 0; j < nu*m; j++)
        {
           pc.printf("%f ",H[i][j]);
        }
           pc.printf("\n\r");
    }
    */
    // Até agora, H foi calculado corretamente, cross-check com o MATLAB
    double tol = 0.00001;

    rows = m*nu, col = m*nu;
    double** Hlu = new double*[rows];

    for (int i = 0; i < rows; i++)
        Hlu[i] = new double[col];

    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < col; j++) {
            Hlu[i][j]=H[i][j];   // Hlu = H
        }
    }

    int_T* Plu = new int_T[m*nu+1];
    //P of size N+1


    int flag = LUPDecompose(Hlu,m*nu,tol,Plu);

    //pc.printf("%d",flag);

    rows = m*nu, col = m*nu;
    Hinv = new real_T*[rows];

    for (int i = 0; i < rows; i++)
        Hinv[i] = new real_T[col];

    rows = m*nu, col = m*nu;
    double** Hinvdp = new double*[rows];

    for (int i = 0; i < rows; i++)
        Hinvdp[i] = new double[col];


    LUPInvert(Hlu,Plu,m*nu,Hinvdp);

    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < col; j++) {
            Hinv[i][j]=Hinvdp[i][j];   // Hlu = H
        }
    }


    rows = m*nu, col = m*nu;
    nHinv = new real_T*[rows];
    for (int i = 0; i < rows; i++)
        nHinv[i] = new real_T[col];

    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < col; j++) {
            nHinv[i][j] = -Hinv[i][j];
        }
    }


    //P=A_cons*(H\A_cons'); A_cons*inv(H)*A_cons'

    rows = 4*m*nu, col = 4*m*nu;
    P = new real_T*[rows];
    for (int i = 0; i < rows; i++)
        P[i] = new real_T[col];

    rows = 4*m*nu, col = m*nu;
    real_T** Acint = new real_T*[rows];
    for (int i = 0; i < rows; i++)
        Acint[i] = new real_T[col];

    rows = m*nu, col = 4*m*nu;
    real_T** tAc = new real_T*[rows];
    for (int i = 0; i < rows; i++)
        tAc[i] = new real_T[col];

    matr_mult(4*m*nu,m*nu,m*nu,Ac,Hinv,Acint);
    matr_t(4*m*nu,m*nu,Ac,tAc);
    matr_mult(4*m*nu,m*nu,4*m*nu,Acint,tAc,P);

    rows = m*nu, col = 4*m*nu;
    nHinvtAc = new real_T*[rows];
    for (int i = 0; i < rows; i++)
        nHinvtAc[i] = new real_T[col];

    matr_mult(m*nu,m*nu,4*m*nu,nHinv,tAc,nHinvtAc);


    // Memory deallocation 2, not strictly necessary but who knows compiler's crazy -> function
    for (int i = 0; i < m*nu; i++) {
        delete [] Imu[i];
        delete [] tThetabar[i];
        delete [] Hlu[i];
        delete [] tAc[i];
    }
    delete [] Imu;
    delete [] tThetabar;
    delete [] Hlu;
    delete [] tAc;
    Imu=0;
    tThetabar=0;
    Hlu=0;
    tAc=0;

    for (int i = 0; i < 4*m*nu; i++) {
        delete [] Acint[i];
    }
    delete [] Acint;
    Acint=0;



    delete [] Plu;
    Plu = 0;

    //pc.printf("%p\n\r",&**Hinv);
    //pc.printf("Tudo ok");
}

// Constructor
// Inputs: control horizon m, prediction horizon p, output weigth q, control signal weight r, slew rate dumax
MPC_Gen::MPC_Gen(int_T mi, int_T pi, real_T (&qi)[ny], real_T (&ri)[nu], real_T (&umaxi)[nu], real_T (&umini)[nu], real_T dumaxi)//, const int p, const float qi, const float ri, const float dumaxi, const int nxi
    : m(mi),p(pi),q(qi),r(ri),umax(umaxi),umin(umini),dumax(dumaxi)
{

    // Constructor, no routines

}

// Destructor
MPC_Gen::~MPC_Gen()
{
    // Currently there is no destructor body generated.
}
// Object routines
void MPC_Gen::matr_mult(int_T n1,int_T n2,int_T n3,real_T **A,real_T **B, real_T **R) // must guarantee correct size
{

    real_T resp[n1][n3];
    for(int i=0; i<n1; i++) {
        for(int j=0; j<n3; j++) {
            resp[i][j]=0;
        }
    }

    for (int i = 0; i < n1; i++) {
        for (int j = 0; j < n3; j++) {
            for (int k = 0; k < n2; k++)
                resp[i][j] += A[i][k]*B[k][j];
        }
    }

    for (int i = 0; i < n1; i++) {
        for (int j = 0; j < n3; j++)
            R[i][j] = resp[i][j];
    }

}

void MPC_Gen::eye(int_T n,real_T **I)
{


    real_T resp[n][n];

    for(int i=0; i<n; i++) {
        for(int j=0; j<n; j++) {
            resp[i][j]=0;
        }
    }

    for (int i = 0; i < n; i++) {
        resp[i][i] = 1;
    }

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            I[i][j]=resp[i][j];
        }
    }

}

void MPC_Gen::matr_sum(int_T n1,int_T n2,real_T **A,real_T **B, real_T **R) // must guarantee correct size
{

    real_T resp[n1][n2];
    for(int i=0; i<n1; i++) {
        for(int j=0; j<n2; j++) {
            resp[i][j]=0;
        }
    }

    for (int i = 0; i < n1; i++) {
        for (int j = 0; j < n2; j++) {
            resp[i][j] = A[i][j]+B[i][j];
        }
    }

    for (int i = 0; i < n1; i++) {
        for (int j = 0; j < n2; j++)
            R[i][j] = resp[i][j];
    }

}

void MPC_Gen::matr_dif(int_T n1,int_T n2,real_T **A,real_T **B, real_T **R) // must guarantee correct size
{

    real_T resp[n1][n2];
    for(int i=0; i<n1; i++) {
        for(int j=0; j<n2; j++) {
            resp[i][j]=0;
        }
    }

    for (int i = 0; i < n1; i++) {
        for (int j = 0; j < n2; j++) {
            resp[i][j] = A[i][j]-B[i][j];
        }
    }

    for (int i = 0; i < n1; i++) {
        for (int j = 0; j < n2; j++)
            R[i][j] = resp[i][j];
    }

}

void MPC_Gen::matr_t(int_T n1,int_T n2,real_T **A, real_T **R) // must guarantee correct size
{

    real_T resp[n2][n1];
    for(int i=0; i<n2; i++) {
        for(int j=0; j<n1; j++) {
            resp[i][j]=0;
        }
    }

    for (int i = 0; i < n1; i++) {
        for (int j = 0; j < n2; j++) {
            resp[j][i] = A[i][j];
        }
    }

    for (int i = 0; i < n2; i++) {
        for (int j = 0; j < n1; j++)
            R[i][j] = resp[i][j];
    }

}

/* INPUT: A - array of pointers to rows of a square matrix having dimension N
 *        Tol - small tolerance number to detect failure when the matrix is near degenerate
 * OUTPUT: Matrix A is changed, it contains both matrices L-E and U as A=(L-E)+U such that P*A=L*U.
 *        The permutation matrix is not stored as a matrix, but in an integer vector P of size N+1
 *        containing column indexes where the permutation matrix has "1". The last element P[N]=S+N,
 *        where S is the number of row exchanges needed for determinant computation, det(P)=(-1)^S
 */
int MPC_Gen::LUPDecompose(double **A, int N, double Tol, int *P)
{

    int i, j, k, imax;
    double maxA, *ptr, absA;

    for (i = 0; i <= N; i++)
        P[i] = i; //Unit permutation matrix, P[N] initialized with N

    for (i = 0; i < N; i++) {
        maxA = 0.0;
        imax = i;

        for (k = i; k < N; k++)
            if ((absA = fabs(A[k][i])) > maxA) {
                maxA = absA;
                imax = k;
            }

        if (maxA < Tol) return 0; //failure, matrix is degenerate

        if (imax != i) {
            //pivoting P
            j = P[i];
            P[i] = P[imax];
            P[imax] = j;

            //pivoting rows of A
            ptr = A[i];
            A[i] = A[imax];
            A[imax] = ptr;

            //counting pivots starting from N (for determinant)
            P[N]++;
        }

        for (j = i + 1; j < N; j++) {
            A[j][i] /= A[i][i];

            for (k = i + 1; k < N; k++)
                A[j][k] -= A[j][i] * A[i][k];
        }
    }

    return 1;  //decomposition done
}

/* INPUT: A,P filled in LUPDecompose; N - dimension
 * OUTPUT: IA is the inverse of the initial matrix
 */
void MPC_Gen::LUPInvert(double **A, int *P, int N, double **IA)
{

    for (int j = 0; j < N; j++) {
        for (int i = 0; i < N; i++) {
            if (P[i] == j)
                IA[i][j] = 1.0;
            else
                IA[i][j] = 0.0;

            for (int k = 0; k < i; k++)
                IA[i][j] -= A[i][k] * IA[k][j];
        }

        for (int i = N - 1; i >= 0; i--) {
            for (int k = i + 1; k < N; k++)
                IA[i][j] -= A[i][k] * IA[k][j];

            IA[i][j] = IA[i][j] / A[i][i];
        }
    }
}//mvec_mult(p*ny,nx,Psi,xmk,el);
void MPC_Gen::mvec_mult(int_T n1,int_T n2,real_T **A,real_T *B, real_T *R) // must guarantee correct size
{

    real_T resp[n1];
    for(int i=0; i<n1; i++) {
        resp[i]=0;
    }

    for (int i = 0; i < n1; i++) {
        for (int k = 0; k < n2; k++)
            resp[i] += A[i][k]*B[k];
    }

    for (int i = 0; i < n1; i++) {
        R[i] = resp[i];
    }

}

void MPC_Gen::mvec_multl(int_T n1,int_T n2,real_T *B,real_T **A, real_T *R) // rowvec(n1)*Matrix(n1,n2)
{

    real_T resp[n2];
    for(int i=0; i<n2; i++) {
        resp[i]=0;
    }

    for (int i = 0; i < n2; i++) {
        for (int k = 0; k < n1; k++)
            resp[i] += A[k][i]*B[k];
    }

    for (int i = 0; i < n2; i++) {
        R[i] = resp[i];
    }

}

;