#include "mbed.h"
#include <math.h>
#include "LCD_DISCO_F746NG.h"

#define MAKE_RGB_VALUE( R,G,B )   (uint32_t)(0xff000000 | ((uint32_t)(R*255.0f)<<16) | ((uint32_t)(G*255.0f)<<8) | ((uint32_t)(B*255.0f)) );

#define BOXES_NUM   (1024)
#define X_MIN       (10)
#define X_MAX       (480-30)
#define Y_MIN       (10)
#define Y_MAX       (272-30)

LCD_DISCO_F746NG lcd;

/* Code - heatmaps and color gradients */
/* http://www.andrewnoske.com/wiki/Code_-_heatmaps_and_color_gradients */
uint32_t getHeatMapColor( float value );

struct box {
    float color;
    uint32_t color_dir;
    int32_t x;
    int32_t y;
    int32_t dx;
    int32_t dy;
    uint32_t x_dir;
    uint32_t y_dir;
};

int main()
{
    struct box boxes[BOXES_NUM];

    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"FLYING BOXES DEMO", CENTER_MODE);
    wait(1);
    
    lcd.SetLayerVisible( 0, DISABLE );
    lcd.SetLayerVisible( 1, DISABLE );

    lcd.SelectLayer(0);
    lcd.SetFont(&Font12);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.Clear(LCD_COLOR_BLACK);
    
    lcd.SelectLayer(1);
    lcd.SetFont(&Font12);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.Clear(LCD_COLOR_BLACK);
                             
    /* BOXES array initialise */   
    srand( time(NULL));
    for( uint32_t idx=0; idx<BOXES_NUM; idx++ ) {
        boxes[idx].color = ((float)(rand()%256))/255.0f;
        boxes[idx].color_dir = rand()%2;
        boxes[idx].x = X_MIN + rand()%(X_MAX-X_MIN);
        boxes[idx].y = Y_MIN + rand()%(Y_MAX-Y_MIN);
        boxes[idx].dx = 1+ rand()%3;
        boxes[idx].dy = 1+ rand()%3;
        boxes[idx].x_dir = rand()%2;
        boxes[idx].y_dir = rand()%2;
    };
    
    uint32_t visible_layer = 0;
    
    /* MAIN loop */  
    while(1) {
        
        while (!(LTDC->CDSR & LTDC_CDSR_VSYNCS)); /* Wait for VSYNC */   
        /* Swap visible layer */
        lcd.SetLayerVisible( visible_layer^1, DISABLE );
        lcd.SetLayerVisible( visible_layer, ENABLE );
        
        lcd.SelectLayer(visible_layer^1); lcd.Clear(LCD_COLOR_BLACK);    
        for( uint32_t idx=0; idx<BOXES_NUM; idx++ ) {
             
            if( boxes[idx].x_dir ) boxes[idx].x += boxes[idx].dx;
            else                   boxes[idx].x -= boxes[idx].dx;
        
            if( boxes[idx].y_dir ) boxes[idx].y += boxes[idx].dy;
            else                   boxes[idx].y -= boxes[idx].dy;
        
            if( (boxes[idx].x < X_MIN) || (boxes[idx].x > X_MAX) ){ boxes[idx].x_dir = !boxes[idx].x_dir; boxes[idx].dx = 1+ rand()%3; };
            if( (boxes[idx].y < Y_MIN) || (boxes[idx].y > Y_MAX) ){ boxes[idx].y_dir = !boxes[idx].y_dir; boxes[idx].dy = 1+ rand()%3; };
            
            if( boxes[idx].x < X_MIN ) boxes[idx].x = X_MIN;
            if( boxes[idx].x > X_MAX ) boxes[idx].x = X_MAX;
        
            if( boxes[idx].y < Y_MIN ) boxes[idx].y = Y_MIN;
            if( boxes[idx].y > Y_MAX ) boxes[idx].y = Y_MAX;
        
            lcd.SetTextColor( getHeatMapColor(boxes[idx].color) ); lcd.FillRect( boxes[idx].x, boxes[idx].y, 20, 20 );
            
            if( boxes[idx].color_dir ) boxes[idx].color += 0.01f;
            else                       boxes[idx].color -= 0.01f;
        
            if( (boxes[idx].color<0.0f) || (boxes[idx].color>1.0f) ) boxes[idx].color_dir = !boxes[idx].color_dir;
        };
        
        visible_layer ^= 1;
    };
};

/* Code - heatmaps and color gradients */
/* http://www.andrewnoske.com/wiki/Code_-_heatmaps_and_color_gradients */
uint32_t getHeatMapColor( float value )
{
  const int NUM_COLORS = 4;
  static float color[NUM_COLORS][3] = { {0,0,1}, {0,1,0}, {1,1,0}, {1,0,0} };
  float R,G,B;
    // A static array of 4 colors:  (blue,   green,  yellow,  red) using {r,g,b} for each.
 
  int idx1;        // |-- Our desired color will be between these two indexes in "color".
  int idx2;        // |
  float fractBetween = 0.0f;  // Fraction between "idx1" and "idx2" where our value is.
 
  if(value <= 0)      {  idx1 = idx2 = 0;            }    // accounts for an input <=0
  else if(value >= 1)  {  idx1 = idx2 = NUM_COLORS-1; }    // accounts for an input >=0
  else
  {
    value = value * (NUM_COLORS-1);        // Will multiply value by 3.
    idx1  = floor(value);                  // Our desired color will be after this index.
    idx2  = idx1+1;                        // ... and before this index (inclusive).
    fractBetween = value - float(idx1);    // Distance between the two indexes (0-1).
  }
 
  R = (color[idx2][0] - color[idx1][0])*fractBetween + color[idx1][0];
  G = (color[idx2][1] - color[idx1][1])*fractBetween + color[idx1][1];
  B = (color[idx2][2] - color[idx1][2])*fractBetween + color[idx1][2];
  
  return MAKE_RGB_VALUE( R,G,B )
}
