/***************************************************************************/
/* mbed_synth.h                                                            */
/*                                                                         */
/* ----------------------------------------------------------------------- */
/* Author: Ron Grier, Lakshmi Baddam                                       */
/* Target: nxp lpc1768                                                     */
/*                                                                         */
/***************************************************************************/
#ifndef MBED_SYNTH_H
#define MBED_SYNTH_H

#include "mbed.h"
#include "PS2Keyboard.h"

/* Macros */
#define SAMP_FREQ   (40000.0) // Sampling frequency
#define SAMP_NUM    (256) // Number of samples per wavetable
#define SHFT_FCTR   (0x01000000) // Used to shift result of frequency
                                 // tuning word to the top8 bits

#define OCT_NUM  (9)
#define NOTE_NUM (12)

/* Declaration of Notes as Frequencies*/
/////////////////
#define C_0  (16)
#define Cs_0 (17)
#define D_0  (18)
#define Ds_0 (19)
#define E_0  (21)
#define F_0  (22)
#define Fs_0 (23)
#define G_0  (25)
#define Gs_0 (26)
/////////////////
#define A_0  (28)
#define As_0 (29)
#define B_0  (31)

#define C_1  (33)
#define Cs_1 (35)
#define D_1  (37)
#define Ds_1 (39)
#define E_1  (41)
#define F_1  (44)
#define Fs_1 (46)
#define G_1  (49)
#define Gs_1 (52)
#define A_1  (55)
#define As_1 (58)
#define B_1  (62)

#define C_2  (65)
#define Cs_2 (69)
#define D_2  (73)
#define Ds_2 (78)
#define E_2  (82)
#define F_2  (87)
#define Fs_2 (93)
#define G_2  (98)
#define Gs_2 (104)
#define A_2  (110)
#define As_2 (117)
#define B_2  (125)

#define C_3  (131)
#define Cs_3 (139)
#define D_3  (147)
#define Ds_3 (156)
#define E_3  (165)
#define F_3  (175)
#define Fs_3 (185)
#define G_3  (196)
#define Gs_3 (208)
#define A_3  (220)
#define As_3 (233)
#define B_3  (247)

#define C_4  (262)
#define Cs_4 (277)
#define D_4  (294)
#define Ds_4 (311)
#define E_4  (330)
#define F_4  (349)
#define Fs_4 (367)
#define G_4  (392)
#define Gs_4 (415)
#define A_4  (440)
#define As_4 (466)
#define B_4  (494)

#define C_5  (523)
#define Cs_5 (554)
#define D_5  (587)
#define Ds_5 (622)
#define E_5  (659)
#define F_5  (698)
#define Fs_5 (740)
#define G_5  (784)
#define Gs_5 (831)
#define A_5  (880)
#define As_5 (932)
#define B_5  (988)

#define C_6  (1047)
#define Cs_6 (1109)
#define D_6  (1175)
#define Ds_6 (1245)
#define E_6  (1319)
#define F_6  (1397)
#define Fs_6 (1480)
#define G_6  (1568)
#define Gs_6 (1661)
#define A_6  (1760)
#define As_6 (1865)
#define B_6  (1976)

#define C_7  (2093)
#define Cs_7 (2218)
#define D_7  (2349)
#define Ds_7 (2489)
#define E_7  (2637)
#define F_7  (2794)
#define Fs_7 (2960)
#define G_7  (3136)
#define Gs_7 (3322)
#define A_7  (3520)
#define As_7 (3729)
#define B_7  (3951)

#define C_8  (4186)
///////////////////
#define Cs_8 (4435)
#define D_8  (4698)
#define Ds_8 (4978)
#define E_8  (5274)
#define F_8  (5588)
#define Fs_8 (5920)
#define G_8  (6272)
#define Gs_8 (6645)
#define A_8  (7040)
#define As_8 (7459)
#define B_8  (7902)
///////////////////

/* Keyboard Bindings */
#define KEY_ON  (0x0)
#define KEY_OFF (0x1)

#define A_key     (0x1c)
#define S_key     (0x1b)
#define D_key     (0x23)
#define F_key     (0x2b)
#define J_key     (0x3b)
#define K_key     (0x42)
#define L_key     (0x4b)
#define Sc_key    (0x4c)
#define W_key     (0x1d)
#define E_key     (0x24)
#define T_key     (0x2c)
#define I_key     (0x43)
#define O_key     (0x44)
#define Left_key  (0x6b)
#define Right_key (0x74)
#define Minus_key (0x4e)
#define Plus_key  (0x55)

#define C_NOTE  (0x0)
#define Cs_NOTE (0x1)
#define D_NOTE  (0x2)
#define Ds_NOTE (0x3)
#define E_NOTE  (0x4)
#define F_NOTE  (0x5)
#define Fs_NOTE (0x6)
#define G_NOTE  (0x7)
#define Gs_NOTE (0x8)
#define A_NOTE  (0x9)
#define As_NOTE (0xA)
#define B_NOTE  (0xB)

/* Typedefs and Enums */
typedef enum _wave {SINE, SQUARE, SAWTOOTH,
            REV_SAWTOOTH, TRIANGLE, EKG,
            SINC, NOISE} Wave;
typedef enum _bool {FALSE, TRUE} Bool;

#endif // MBED_SYNTH_H
