#include "mbed.h"
#include "CAN.h"
  
/* 
Transmitter code
CANBus Tutorial based on lots of example code
*/


Serial pc(PA_9, PA_10);          // tx, rx for Tera Term output

DigitalOut led1(PA_6);            // LED1 displays messsage sent Status
CAN can1(PA_11,PA_12);                // rx, tx , CAN interface
char counter = 0;                 // Counter Variable to store number of sent messages

int main() {
  printf("sending a message via CANbus... ");
  while (1) {       
    // send value to CAN bus and monitor return value to check if CAN
    // message was sent successfully. If so display, increment and toggle
    if (can1.write(CANMessage(1, &counter, 1))) {  
       pc.printf("CANBus Message sent: %d\n", counter);       // display message
       counter++;                                             // increment message counter value
       led1 = !led1;                                          // toggle LED1 to show message sent
    }else{
      can1.reset();                                           // Reset CANbus if there is a problem
    }
    wait(1);                                                  // wait a second  
  }
}