#include "mbed.h"
#include "uLCD_4DGL.h"
#include "Joystick.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "rtos.h"

uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
Nav_Switch myNav( p12, p13, p14, p15, p16);
DigitalIn pb(p20);

//Analog Out Jack
AnalogOut DACout(p18);
//On Board Speaker
PwmOut PWMout(p26);

wave_player waver(&DACout,&PWMout);
SDFileSystem sd(p5, p6, p7, p8, "sd"); // mosi, miso, sck, cs
int Hx2 = 50;
int Px2 = 127;
int count;
void Game_Over(void);
void Thunder(void);
void Shock(void);
void Slam(void);
void Tackle(void);
void display_attacks(void);
int select_attack(void);
void attack(int A);
void redraw(void);
void mew(void);
void attack_sound();

void sound(char * wav)
{
    FILE *wave_file;
    wave_file=fopen(wav,"r");
    PWMout.period(1.0/400000.0);
    // play wav file
    waver.play(wave_file);

    // close wav file
    fclose(wave_file);
}
int D = 0;
void led1_thread(void const *argument)
{
        while(1){
           sound("/sd/battle16.wav");   
        }
}

int main()
{
    
    pb.mode(PullUp); 
    int Position;
    Thread thread1(led1_thread);
    uLCD.cls();
    uLCD.media_init();
    uLCD.set_sector_address(0x0000, 0x07CA);
    uLCD.display_image(0,0);
    
    while (1) {
        int test[2] = {99,99};
        test[1] = test[0];
        test[0] = pb;
        if (test[0] != test[1] && test[0] == 0){
            break;
        }
    }
    uLCD.cls();
    uLCD.set_sector_address(0x0000, 0x06AB);
    for (int i = 70; i > 0; i--){
    uLCD.display_image(i,50);
    wait(.01);
    }
    uLCD.set_sector_address(0x0000, 0x06C6);
    uLCD.display_image(0,3);
    uLCD.locate(0,14);
    uLCD.printf("Lance wants to \nfight!");
    wait(2);
    uLCD.set_sector_address(0x0000, 0x0707);
    uLCD.display_image(0,3);
    wait(.5);
    uLCD.set_sector_address(0x0000, 0x0748);
    uLCD.display_image(0,3);
    wait(.5);
    uLCD.set_sector_address(0x0000, 0x0789);
    uLCD.display_image(0,3);
    wait(.5);
    redraw();
    
    while (1) {
       Position = select_attack();
        if (myNav.fire()){
            attack(Position);
            wait(.3);
            mew();
        }
    }
}

void display_attacks(void){
    uLCD.locate(0,14);
    uLCD.printf("Tackle");
    uLCD.locate(8,14);
    uLCD.printf("Thunder");
    uLCD.locate(0,15);
    uLCD.printf("Slam");
    uLCD.locate(8,15);
    uLCD.printf("Shock");
}

int select_attack(void){
    if (myNav.right()){
        uLCD.rectangle(0, 111, 50, 119, BLACK);
        uLCD.rectangle(0, 119, 50, 127, BLACK);
        uLCD.rectangle(55, 119, 105, 127, BLACK);
        
        uLCD.rectangle(55, 111, 105, 119, 0x1F);
        count = 1;
        wait(.2);
    }
    if (myNav.up()){
        uLCD.rectangle(55, 119, 105, 127, BLACK);
        uLCD.rectangle(55, 111, 105, 119, BLACK);
        uLCD.rectangle(0, 119, 50, 127, BLACK);
        
        uLCD.rectangle(0, 111, 50, 119, 0x1F);
        count = 2;
        wait(.2);
    }
    if (myNav.left()){
        uLCD.rectangle(55, 119, 105, 127, BLACK);
        uLCD.rectangle(0, 111, 50, 119, BLACK);
        uLCD.rectangle(55, 111, 105, 119, BLACK);
        
        uLCD.rectangle(0, 119, 50, 127, 0x1F);
        count = 3;
        wait(.2);
    }
    if (myNav.down()){
        uLCD.rectangle(0, 119, 50, 127, BLACK);
        uLCD.rectangle(0, 111, 50, 119, BLACK);
        uLCD.rectangle(55, 111, 105, 119, BLACK);
        
        uLCD.rectangle(55, 119, 105, 127, 0x1F);
        count = 4;
        wait(.2);
    }
    
    return count;     
}

void attack(int A) {
    if (A == 1){
        uLCD.rectangle(55, 111, 105, 119, BLACK);
        wait(.2);
        uLCD.rectangle(55, 111, 105, 119, 0x1F);
        Thunder();
    }
    if (A == 2){
        uLCD.rectangle(0, 111, 50, 119, BLACK);
        wait(.2);
        uLCD.rectangle(0, 111, 50, 119, 0x1F);
        Tackle();
    }
    if (A == 3){
        uLCD.rectangle(0, 119, 50, 127, BLACK);
        wait(.2);
        uLCD.rectangle(0, 119, 50, 127, 0x1F);
        Slam();
    }
    if (A == 4){
        uLCD.rectangle(55, 119, 105, 127, BLACK);
        wait(.2);
        uLCD.rectangle(55, 119, 105, 127, 0x1F);
        Shock();
    }

}


void Thunder(void) {
    uLCD.locate(0,14);
    uLCD.set_sector_address(0x0000, 0x0000);
    uLCD.display_image(0,0);
    uLCD.printf("Pikachu used \nThunder!");
    wait(1.5);
    uLCD.set_sector_address(0x0000, 0x0249);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x028A);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x02CB);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x030C);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x034D);
    uLCD.display_image(0,0);
    wait(.2);
    Hx2 = Hx2 - 20;
    redraw();
}

void Shock(void) {
    uLCD.locate(0,14);
    uLCD.set_sector_address(0x0000, 0x0000);
    uLCD.display_image(0,0);
    uLCD.printf("Pikachu used \nShock!");
    wait(1.5);
    for (int i = 0; i < 3; i++){
    uLCD.set_sector_address(0x0000, 0x038E);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x03CF);
    uLCD.display_image(0,0);
    wait(.2);
    }
    Hx2 = Hx2 - 5;
    redraw();
}

void Slam(void){
    uLCD.locate(0,14);
    uLCD.set_sector_address(0x0000, 0x0000);
    uLCD.display_image(0,0);
    uLCD.printf("Pikachu used \nSlam!");
    wait(1.5);
    uLCD.set_sector_address(0x0000, 0x0041);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x0082);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x00C3);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x0104);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x00C3);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x0082);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x0041);
    uLCD.display_image(0,0);
    wait(.2);
    Hx2 = Hx2 - 13;
    redraw();
}

void Tackle(void){
    uLCD.locate(0,14);
    uLCD.set_sector_address(0x0000, 0x0000);
    uLCD.display_image(0,0);
    uLCD.printf("Pikachu used \nTackle!");
    wait(1.5);
    uLCD.set_sector_address(0x0000, 0x0000);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x0145);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x0186);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x01C7);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x0208);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x01C7);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x0186);
    uLCD.display_image(0,0);
    wait(.2);
    Hx2 = Hx2 - 8;
    redraw();
}
void redraw(void){
    uLCD.set_sector_address(0x0000, 0x0000);
    uLCD.display_image(0,0);
    
    display_attacks();
    uLCD.locate(0,1);
    uLCD.printf("HP");
    uLCD.locate(11,6);
    uLCD.printf("HP");
    uLCD.filled_rectangle(0, 20, Hx2, 25, RED); // enemy Health
    uLCD.filled_rectangle(77, 60, Px2, 65, RED); // player Health
    if (Hx2 <= 0 || Px2 <= 0){
        wait(2);
        Game_Over();
    }
}

void mew(void){
    if(Hx2 % 2){
    uLCD.locate(0,14);
    uLCD.set_sector_address(0x0000, 0x0000);
    uLCD.display_image(0,0);
    uLCD.printf("Mew used \nPsybeam!");
    wait(1.5);
    uLCD.set_sector_address(0x0000, 0x0410);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x0451);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x0492);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x04D3);
    uLCD.display_image(0,0);
    wait(.2);
    Px2 = Px2 - 9;
    }
    else {
    uLCD.locate(0,14);
    uLCD.set_sector_address(0x0000, 0x0000);
    uLCD.display_image(0,0);
    uLCD.printf("Mew used \nAncient Power!");
    wait(1.5);
    uLCD.set_sector_address(0x0000, 0x0514);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x0555);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x0514);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x0596);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x05D7);
    uLCD.display_image(0,0);
    wait(.2);
    uLCD.set_sector_address(0x0000, 0x0618);
    uLCD.display_image(0,0);
    wait(.2);
    Px2 = Px2 - 12;    
    }

redraw();
}

void Game_Over(void){
    uLCD.cls();
    uLCD.set_sector_address(0x0000, 0x084C);
    uLCD.display_image(0,0);
    //wait(.2);
    wait(30);
    exit(0);
}