/*
  main.cpp
  2014 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2014-4-29

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "mbed.h"
#include "USBSerial.h"
#include "SDFileSystem.h"

SDFileSystem sd(P1_22, P1_21, P1_20, P1_23, "sd"); // mosi, miso, sclk, cs
USBSerial pc;
FILE *fp;

int main()
{
    pc.printf("Initializing\r\n");

    fp = fopen("/sd/hello.txt", "r");
    if (fp != NULL) {
        fclose(fp);
        remove("/sd/hello.txt");
        pc.printf("Remove an existing file with the same name\r\n");
    }

    fp = fopen("/sd/hello.txt", "w");
    if (fp == NULL) {
        pc.printf("Unable to write the file\r\n");
    } else {
        fprintf(fp, "mbed SDCard application!");
        fclose(fp);
        pc.printf("File successfully written!\r\n");
    }
}