#include "mbed.h"

Serial gprs(p28,p27); //Hardware Serial
//Serial gprs(p9,p10);   //Software Serial
Serial pc(USBTX,USBRX);

Timer timeCnt;

int waitForResp(char *resp, int timeout)
{
    int len = strlen(resp);
    int sum=0;
    timeCnt.start();

    while(1) {
        if(gprs.readable()) {
            char c = gprs.getc();
            sum = (c==resp[sum]) ? sum+1 : 0;
            if(sum == len)break;
        }
        if(timeCnt.read() > timeout) {  // time out
            timeCnt.stop();
            timeCnt.reset();
            pc.printf("Error:time out");
            return -1;
        }
    }
    timeCnt.stop();                 // stop timer
    timeCnt.reset();                    // clear timer
    while(gprs.readable()) {      // display the other thing..
        char c = gprs.getc();
    }

    return 0;
}

int sendCmdAndWaitForResp(char *cmd, char *resp, int timeout)
{
    gprs.puts(cmd);
    return waitForResp(resp,timeout);
}

int callUp(char *number)
{
    if(0 != sendCmdAndWaitForResp("AT+COLP=1\r\n","OK",5)) {
        pc.printf("Error:COLP");
        return -1;
    }
    wait(1);
    gprs.printf("\r\nATD%s;\r\n",number);
    return 0;
}

int main()
{
    pc.baud(19200);
    gprs.baud(19200);

    for(int i = 0; i < 5; i++) {
        wait(1);
        printf("wait\n");
    }
    callUp("139****7382");
    while(1);
}