#include "gprs.h"

#define PHONE_NUMBER    "139****7382"
#define IP_ADDRSS       "216.52.233.120" //api.xively.com
#define PORT            "80" //port addr
#define FEED_ID         "your feeed ID"
#define SENSOR_ID       "your sensor ID"
#define XIVELY_KEY      "your Xively Key"
#define REQUEST_LENGTH  36
#define DATA_LENGTH     90
#define HEAD_LEN        270

#define NETWORK_APN     "CMNET"  //replace APN in your country

#define PINPWR          P1_2    // power on EG 10, low enable
#define PINONOFF        P1_7    // switch of EG10, low enable, low for 2s to turn on EG10

DigitalOut eg10_pwr(PINPWR);
DigitalOut eg10_on(PINONOFF);
GPRS gprs(USBTX, USBRX,115200,PHONE_NUMBER);
AnalogIn soundSensor(P0_11);

void EG10_PowerUp(void)
{
    eg10_pwr = 1;
    eg10_on  = 1;
    wait(2);
    eg10_pwr = 0;
    eg10_on = 0;
    wait(2);
    eg10_on = 1;
    wait(2);
}

int putDataToXively(float sensorValue)
{
    char request[REQUEST_LENGTH];
    char dataStream[DATA_LENGTH];
    char head[HEAD_LEN];
    snprintf(request,REQUEST_LENGTH,"PUT /v2/feeds/%s HTTP/1.1\r\n",FEED_ID);
    snprintf(dataStream,DATA_LENGTH,"{\"version\":\"1.0.0\", \"datastreams\" : [{ \"id\" : \"%s\", \"current_value\" : \"%f\"}]}\r\n",SENSOR_ID,sensorValue);
    int dataLen = strlen(dataStream);
    snprintf(head,HEAD_LEN,"%sHost: api.xively.com\r\nX-ApiKey: %s\r\nUser-Agent: Xively-Arduino-Lib/1.0\r\nContent-Length: %d\r\n\r\n%s",request,XIVELY_KEY,dataLen,dataStream);
    if(0 != gprs.networkInit(NETWORK_APN,NULL,NULL)){ //APN,User,PassWd
        return -1;    
    }
    if(0 != gprs.connectTCP(IP_ADDRSS,PORT)) {
        goto STOP;
    }
    wait(5);
    if(0 != gprs.sendTCPData(head)) {
        goto STOP;
    }
STOP:
    gprs.closeTCP();
    return 0;
}

int main()
{
    EG10_PowerUp();
    while(0 != gprs.init()) {
        wait(2);
    }
    while(1) {
        putDataToXively(10*soundSensor.read());
        wait(10);
    }
}
