/*
  main.cpp
  2013 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2013-7-21

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "mbed.h"
#include "string.h"
#include "gprs.h"

#define SEND_SMS_TEST           0
#define CALL_UP_TEST            0
#define ANSWER_TEST             0
#define READ_SMS_TEST           0

#define PHONE_NUMBER            "150****9566"

#define PINPWR                  P1_2 // power on EG 10, low enable
#define PINONOFF                P1_7 // switch of EG10, low enable, low for 2s to turn on EG10

DigitalOut eg10_pwr(PINPWR);
DigitalOut eg10_on(PINONOFF);
GPRS  gprsTest(P0_19, P0_18, 115200, PHONE_NUMBER);

void EG10_PowerUp(void)
{
    eg10_pwr = 1;
    eg10_on  = 1;
    wait(2);
    eg10_pwr = 0;
    eg10_on = 0;
    wait(2);
    eg10_on = 1;
    wait(2);
}

int main(void)
{
    EG10_PowerUp();
    while(0 != gprsTest.init()) {
        wait(2);
    }

#if CALL_UP_TEST
    gprsTest.callUp(PHONE_NUMBER);
#endif

#if SEND_SMS_TEST
    gprsTest.sendSMS(PHONE_NUMBER,"hello,lawliet");
#endif

#if ANSWER_TEST || READ_SMS_TEST
    while(1) {
        int messageType = gprsTest.loopHandle();
        if(MESSAGE_RING == messageType) {
            gprsTest.answer();
        } else if(MESSAGE_SMS == messageType) {
            char smsMessage[SMS_MAX_LENGTH];
            gprsTest.getSMS(smsMessage);
        }
    }
#endif

    return 0;
}