/*
  main.cpp
  2013 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2014-1-21

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "mbed.h"
#include "USBSerial.h"

#define PINPWR          P1_2    // power on EG 10, low enable
#define PINONOFF        P1_7    // switch of EG10, low enable, low for 2s to turn on EG10

DigitalOut eg10_pwr(PINPWR);
DigitalOut eg10_on(PINONOFF);

Serial gprs(USBTX, USBRX);
USBSerial pc;

void EG10_PowerUp(void)
{
    eg10_pwr = 1;
    eg10_on  = 1;
    wait(2);
    eg10_pwr = 0;
    eg10_on = 0;
    wait(2);
    eg10_on = 1;
    wait(2);
}

// Called by ISR
void settingsChanged(int baud, int bits, int parity, int stop)
{
    const Serial::Parity parityTable[] = {Serial::None, Serial::Odd, Serial::Even, Serial::Forced0, Serial::Forced1};

    if (stop != 2) {
        stop = 1;   // stop bit(s) = 1 or 1.5
    }

    gprs.baud(baud);
    gprs.format(bits, parityTable[parity], stop);
}

int main()
{
    pc.attach(settingsChanged);
    EG10_PowerUp();

    while (1) {
        while (gprs.readable()) {
            pc.putc(gprs.getc());
        }

        while (pc.readable()) {
            gprs.putc(pc.getc());
        }
    }
}

