#include "mbed.h"
#include "EthernetInterface.h"


PwmOut pump_tick(LED1);
DigitalOut tick(LED2);
Ticker pkt;
InterruptIn *flow;
PwmOut *pump;

unsigned int flowcount = 0;
unsigned int lastflow;

float pi = 3.1415926535897932384626433832795;

void flowtick() {
    tick.write(1);
    flowcount++;
    tick.write(0);
}

int main() {
 
    EthernetInterface eth;
    UDPSocket sock;
    Endpoint seven;
    eth.init("192.168.9.8", "255.255.255.0", "192.168.9.1");
    eth.connect();
    sock.init();
    seven.set_address("192.168.9.7", 37);
    char out_buffer[8]; // Does not matter
    
    flow = new InterruptIn(p5);
    flow->mode(PullUp);
    pump = new PwmOut(p21);  
    
    pump->period(1.0);
    pump_tick.period(1.0);
    
    lastflow = flowcount;
    
    flow->rise(&flowtick);
    
    float t = 0.0;
    while(1) {   
        if(t < pi) {
            t += 0.01;
            pump->write(1 - cos(t));
            pump_tick.write(1 - cos(t));
        }
        
        wait(0.1);
        if(flowcount > lastflow) {
            sprintf(out_buffer, "%07d", flowcount);
            sock.sendTo(seven, out_buffer, sizeof(out_buffer));
            lastflow = flowcount;
        }
    }
    sock.close();
    eth.disconnect();
}
