class Pump {
    private:
    DigitalOut *io;
    DigitalOut *led;
    int on_v, off_v;
    Timeout timeout;
    unsigned char status;
    
    public:
    Pump(PinName p, DigitalOut *led, int on_value) {
        this->io = new DigitalOut(p);
        if(on_value == 1) {
            this->on_v = 1;
            this->off_v = 0;
        } else {
            this->on_v = 0;
            this->off_v = 1;
        }
        this->led = led;
        this->off();
    }
    
    void set_status(int s) {
        this->status = s;
        this->led->write(s);
    }
    
    void on(float time) {
        while(this->status);
        this->io->write(this->on_v);
        this->set_status(1);
        this->timeout.attach(this, &Pump::off, time);
    }
    
    void off() {
        this->io->write(this->off_v);
        this->set_status(0);
    }
    
    ~Pump() {
        this->off();
        delete io;
    }
 };
 