
class Flow_Controlled {
    private :
        vector<Pump *>pumps;
        DigitalOut *enable;
        DigitalIn *flow;

    public:
    
    Flow_Controlled(int on_value) {    
        this->enable = new DigitalOut(p17);
        this->pumps.push_back(new Pump(p18, &led1, on_value));
        this->pumps.push_back(new Pump(p19, &led2, on_value));
        this->flow = new DigitalIn(p20);
    }
    
    void raw_water(unsigned int litres) {
        this->pumps[0]->on(0.7 * litres);
    }
    
    void recycled_water(unsigned int litres) {
        this->pumps[1]->on(0.7 * litres);
    }
    
    void all_off() {
        for(int p = 0; p < pumps.size(); p++)
            this->pumps[p]->off();
        this->enable->write(0);        
    }
    
    ~Flow_Controlled() {
        for(int p = 0; p < pumps.size(); p++)
            delete this->pumps[p];
        delete this->enable;
        delete this->flow;
        
    }
};
