#include "mbed.h"
#include "Synchro.h"

Serial pc(USBTX, USBRX); // tx, rx

int main() 
{   
    Synchro sync[]={Synchro(p21,p20),Synchro(p22,p19)};
    pc.baud(115200);
    int channel;
    int command;
    float value;
    while (1)
    {    
        channel=0;
        command=0;
        value=0;      
        if (pc.readable())
        {
            pc.scanf("<%d;%d;%f>",&channel,&command,&value);
            switch (command)
            {
                case 1:
                    pc.printf("Processing <%d %d %f> : Triggering\r\n",channel,command,value);
                    sync[channel].trigger(value);
                    break;              
                case 2:                    
                    pc.printf("Processing <%d %d %f> Shifting phase\r\n",channel,command,value);
                    sync[channel].phase=int(value);
                    break;
                case 3:                    
                    pc.printf("Processing <%d %d %f> Delaying trigger\r\n",channel,command,value);
                    sync[channel].delay=int(value);
                    break;
                case 4:                                        
                    pc.printf("Processing <%d %d %f> Setting trigger duration\r\n",channel,command,value);
                    sync[channel].duration=int(value);
                    break;
                case 5:                     
                    pc.printf("Processing <%d %d %f> Setting pulse duration\r\n",channel,command,value);
                    sync[channel].pulse=value;
                    break;
                case 6:                     
                    pc.printf("Processing <%d %d %f> Setting pulse polarity\r\n",channel,command,value);
                    sync[channel].polarity=int(value);
                    break;
                case 7:
                    value=sync[channel].period;                
                    pc.printf("Processing <%d %d %f> Getting period\r\n",channel,command,value);
                    break;
                default:
                    pc.printf("Command Unknown <%d %f>\r\n",command,value);
                
            }            
        }    
    }
}