#ifndef SYNCHRO_H
#define SYNCHRO_H
#include "mbed.h"

class Synchro
{
    public:
    Synchro(PinName sync, PinName pout);//incomming signal to trigg on, output synced signal
    bool polarity;      // polarity of the pulse (active high/low)
    bool trig;          //memorize trigger event 
    float pulse;        //sync pulse duration in degre
    float phase;        //phase shifting compared to incominf sync
    float period;       //period measured in sec
    uint32_t delay;     //number of cycles before firing sync pulse
    uint32_t duration;  //number of cycles during which the trigger is held,
                        // if duration==0 : enter in sync mode (output shifted incoming sync) else, trigger mode : oneshot pulse
    void trigger(bool value);//set the trigger
    
    private:
    uint32_t _delay; //counter for delaying pulse in cycle
    uint32_t _duration;//counter for duration of pulse in cycle
    InterruptIn _irq; //incoming sync use interrupt 
    DigitalOut _pout; //output sync
    Timer timer;// period measurement
    Timeout _phase;//phase shifting using timeout rather than wait
    Timeout _pulse;//pulse duration using timeout   
    void _sync(void); //function attached to the IRQ
    void _up(void);//set output active taking care of polarity
    void _down(void); //set output inactive taking care of polarity
    
};

#endif